#include <bits/stdc++.h>
#include "testlib.h"
 
using namespace std;
 
constexpr int max_n = 2e5;
 
auto read_output(InStream &stream, int n)
{
    return stream.readInt(1, n, "output");
}
 
auto read_input(InStream &stream)
{
    const auto t = stream.readInt(0, 0, "t");
    stream.readEoln();
    const auto n = stream.readInt(1, max_n, "n");
    stream.readEoln();
 
    const auto cards = stream.readInts(n, 1, n, "cards");
    stream.readEoln();
    stream.readEof();
 
    return cards;
}
 
int main(int argc, char *argv[])
{
    registerTestlibCmd(argc, argv);
 
    const auto cards = read_input(inf); // real input
    char *envfile = getenv("SECRET_LOG_FILE");
    InStream log;
    log.init(fopen(envfile, "r"), _output);
    const auto j = read_output(log, cards.size()) - 1; // should be ouf1
    const auto num = read_output(ouf, cards.size()); // should be ouf2
 
    if (cards[j] == num)
    {
        quitf(_ok, "n = %d", cards.size());
    }
    else
    {
        cerr << "cards[" << j << "] == " << cards[j] << " != " << num << endl;

        quitf(_wa, "Wrong guess");
    }
}

