use self::template::random::*;
pub use self::template::*;
use std::{
    io::{stdin, stdout, BufWriter, Write},
    str::FromStr,
};

fn solve_test(scan: &mut impl Scanner, cout: &mut impl Write) -> Result<(), std::io::Error> {
    let args: Vec<String> = std::env::args().collect();

    assert!(args.len() >= 2);

    let seed: u64 = args[1].parse().unwrap();

    let _t: u64 = scan.next();
    let n: u64 = scan.next();

    let mut arr: Vec<_> = (0..n).map(|_| scan.next::<u64>()).collect();

    let mut rnd = Xoshiro256SS::new(seed);

    if args[2..].contains(&String::from_str("shuffle_seats").unwrap()) {
        rnd.shuffle(&mut arr);
    }

    if args[2..].contains(&String::from_str("shuffle_values").unwrap()) {
        let mut map: Vec<_> = (1..=n).collect();
        rnd.shuffle(&mut map);

        for x in &mut arr {
            *x = map[(*x - 1) as usize];
        }
    }

    if args[2..].contains(&String::from_str("reverse_seats").unwrap()) {
        arr.reverse();
    }

    if args[2..].contains(&String::from_str("reverse_values").unwrap()) {
        for x in &mut arr {
            *x = n + 1 - *x;
        }
    }

    writeln!(cout, "0")?;
    writeln!(cout, "{n}")?;
    writeln!(
        cout,
        "{}",
        arr.into_iter()
            .map(|x| x.to_string())
            .collect::<Vec<_>>()
            .join(" ")
    )
}

pub fn solve(scan: &mut impl Scanner, cout: &mut impl Write) {
    let t = 1;

    for _test in 0..t {
        solve_test(scan, cout).unwrap();
    }

    cout.flush().unwrap();
}

#[cfg(feature = "generate")]
pub fn generate(_test: usize, cout: &mut impl Write) -> Result<(), std::io::Error> {
    cout.flush()
}

#[allow(dead_code)]
fn main() {
    solve(
        &mut IOScanner::new(stdin().lock()),
        &mut BufWriter::new(stdout().lock()),
    );
}

pub mod template {
    use std::io::BufRead;
    use std::str::FromStr;

    pub trait Scanner {
        fn checked_next_line(&mut self) -> Option<String>;

        fn checked_next<T: FromStr>(&mut self) -> Option<T>;

        #[allow(dead_code)]
        fn next<T: FromStr>(&mut self) -> T;

        fn seek(&mut self) -> bool;
    }

    pub struct IOScanner<ReadType: BufRead> {
        read: ReadType,
        buffer: Vec<String>,
    }

    impl<ReadType: BufRead> Scanner for IOScanner<ReadType> {
        fn checked_next_line(&mut self) -> Option<String> {
            self.buffer.clear();
            let mut input = String::new();
            if self.read.read_line(&mut input).expect("Failed read") > 0 {
                Some(input)
            } else {
                None
            }
        }

        fn checked_next<T: FromStr>(&mut self) -> Option<T> {
            loop {
                if let Some(token) = self.buffer.pop() {
                    return Some(token.parse().ok().expect("Failed parse"));
                }
                if let Some(input) = self.checked_next_line() {
                    self.buffer = input.split_whitespace().rev().map(String::from).collect();
                } else {
                    return None;
                }
            }
        }

        fn next<T: FromStr>(&mut self) -> T {
            self.checked_next().expect("Read after EOF")
        }

        fn seek(&mut self) -> bool {
            let mut input = String::new();

            while let Ok(cnt) = self.read.read_line(&mut input) {
                if cnt == 0 {
                    break;
                }
                let line = input.trim();
                if !line.is_empty() && line.matches("=").count() == line.len() {
                    return true;
                }
                input.clear();
            }

            false
        }
    }

    impl<ReadType: BufRead> IOScanner<ReadType> {
        pub fn new(read: ReadType) -> IOScanner<ReadType> {
            IOScanner {
                read,
                buffer: Vec::<String>::default(),
            }
        }
    }

    pub(crate) mod random {
        use std::collections::Bound;
        use std::ops::RangeBounds;

        #[derive(Debug, Clone, Ord, PartialOrd, Eq, PartialEq, Hash)]
        pub struct Xoshiro256SS {
            state: [u64; 4],
        }

        #[allow(dead_code)]
        impl Xoshiro256SS {
            fn splitmix64(state: &mut u64) -> u64 {
                *state = state.wrapping_add(0x9E3779B97f4A7C15u64);
                let mut result = state.clone();
                result = (result ^ (result >> 30)).wrapping_mul(0xBF58476D1CE4E5B9);
                result = (result ^ (result >> 27)).wrapping_mul(0x94D049BB133111EB);
                result ^ (result >> 31)
            }

            pub fn new(mut seed: u64) -> Self {
                let mut state = [0; 4];

                for it in &mut state {
                    *it = Self::splitmix64(&mut seed);
                }

                Self { state }
            }

            pub fn generate(&mut self) -> u64 {
                let s = &mut self.state;
                let result = s[1].wrapping_mul(5).rotate_left(7).wrapping_mul(9);
                let t = s[1] << 17;

                s[2] ^= s[0];
                s[3] ^= s[1];
                s[1] ^= s[2];
                s[0] ^= s[3];

                s[2] ^= t;
                s[3] = s[3].rotate_left(45);

                result
            }

            pub fn gen_modulo(&mut self, modulo: u64) -> u64 {
                self.generate() % modulo
            }

            pub fn gen_range(&mut self, range: impl RangeBounds<u64>) -> u64 {
                if range.start_bound() == Bound::Unbounded && range.end_bound() == Bound::Unbounded
                {
                    return self.generate();
                }

                let start = match range.start_bound() {
                    Bound::Included(x) => *x,
                    Bound::Excluded(x) => x + 1,
                    Bound::Unbounded => 0,
                };

                let len = match range.end_bound() {
                    Bound::Included(x) => x.wrapping_add(1),
                    Bound::Excluded(x) => *x,
                    Bound::Unbounded => 0,
                }
                .wrapping_sub(start);

                self.gen_modulo(len) + start
            }

            pub fn shuffle<T>(&mut self, arr: &mut [T]) {
                for i in 1..arr.len() {
                    arr.swap(i, self.gen_modulo((i + 1) as u64) as usize);
                }
            }
        }
    }
}
