use self::runtime_modulo::RuntimeModulo64;

pub use self::template::*;
use std::io::{BufWriter, Write, stdin, stdout};

static mut MOD: u64 = 0;

#[derive(Default)]
struct ModValue {}

impl From<ModValue> for u64 {
    fn from(_value: ModValue) -> Self {
        unsafe { MOD }
    }
}

type Mod = RuntimeModulo64<ModValue>;

fn solve_test(scan: &mut impl Scanner, cout: &mut impl Write) -> Result<(), std::io::Error> {
    let t: u64 = scan.next();
    let n = scan.next();

    unsafe { MOD = if t == 0 { n } else { n + 1 } };

    let arr: Vec<_> = (0..n)
        .map(|_| Mod::new_unchecked(scan.next::<u64>() - 1))
        .collect();

    match t {
        0 => writeln!(cout, "{}", arr.into_iter().sum::<Mod>().unwrap() + 1),
        _ => writeln!(
            cout,
            "{}",
            (Mod::new_unchecked(t - 1) - arr.into_iter().sum::<Mod>()).unwrap() + 1
        ),
    }
}

pub fn solve(scan: &mut impl Scanner, cout: &mut impl Write) {
    let t = 1;

    for _test in 0..t {
        solve_test(scan, cout).unwrap();
    }

    cout.flush().unwrap();
}

#[cfg(feature = "generate")]
pub fn generate(_test: usize, cout: &mut impl Write) -> Result<(), std::io::Error> {
    cout.flush()
}

#[allow(dead_code)]
fn main() {
    solve(
        &mut IOScanner::new(stdin().lock()),
        &mut BufWriter::new(stdout().lock()),
    );
}

pub mod template {
    pub(crate) mod runtime_modulo {
        use std::fmt::{Debug, Display, Formatter};
        use std::iter::{Product, Sum};
        use std::marker::PhantomData;
        use std::ops::{Add, AddAssign, Div, DivAssign, Mul, MulAssign, Neg, Sub, SubAssign};

        macro_rules! impl_ref_runtime_modulo_binary_op {
            ($name:ident, $small:ty, $op_trait:ident, $op_fn:ident) => {
                impl<T: Default> $op_trait<&$name<T>> for $name<T>
                where
                    $small: From<T>,
                {
                    type Output = <$name<T> as $op_trait<$name<T>>>::Output;

                    fn $op_fn(self, rhs: &$name<T>) -> Self::Output {
                        self.$op_fn(*rhs)
                    }
                }

                impl<'a, T: Default> $op_trait<$name<T>> for &'a $name<T>
                where
                    $small: From<T>,
                {
                    type Output = <$name<T> as $op_trait<$name<T>>>::Output;

                    fn $op_fn(self, rhs: $name<T>) -> Self::Output {
                        (*self).$op_fn(rhs)
                    }
                }

                impl<'a, T: Default> $op_trait<&$name<T>> for &'a $name<T>
                where
                    $small: From<T>,
                {
                    type Output = <$name<T> as $op_trait<$name<T>>>::Output;

                    fn $op_fn(self, rhs: &$name<T>) -> Self::Output {
                        (*self).$op_fn(*rhs)
                    }
                }
            };
        }

        macro_rules! impl_ref_runtime_modulo_op_assign {
            ($name:ident, $small:ty, $op_trait:ident, $op_fn:ident) => {
                impl<T: Default> $op_trait<&Self> for $name<T>
                where
                    $small: From<T>,
                {
                    fn $op_fn(&mut self, rhs: &Self) {
                        self.$op_fn(*rhs)
                    }
                }
            };
        }

        macro_rules! runtime_modulo {
            ($name:ident, $small:ty, $big:ty, $name_str:expr) => {
                impl<T: Default> Clone for $name<T>
                where
                    $small: From<T>,
                {
                    fn clone(&self) -> Self {
                        Self {
                            r: self.r,
                            _phantom: PhantomData,
                        }
                    }
                }

                impl<T: Default> Copy for $name<T> where $small: From<T> {}

                impl<T: Default> $name<T>
                where
                    $small: From<T>,
                {
                    pub fn new_unchecked(r: $small) -> Self {
                        debug_assert!(r < <$small>::from(T::default()));

                        Self {
                            r,
                            _phantom: PhantomData,
                        }
                    }

                    pub fn new(r: $small) -> Self {
                        Self {
                            r: r % <$small>::from(T::default()),
                            _phantom: PhantomData,
                        }
                    }

                    pub const fn unwrap(self) -> $small {
                        self.r
                    }

                    pub fn pow(self, y: $small) -> Self {
                        if y == 0 {
                            Self::new(1)
                        } else if y % 2 == 0 {
                            self.pow(y / 2).sqr()
                        } else {
                            self * self.pow(y - 1)
                        }
                    }

                    pub fn recip(self) -> Self {
                        self.pow(<$small>::from(T::default()) - 2)
                    }

                    pub fn sqr(self) -> Self {
                        self * self
                    }
                }

                impl<T: Default> From<$small> for $name<T>
                where
                    $small: From<T>,
                {
                    fn from(r: $small) -> Self {
                        Self::new(r)
                    }
                }

                impl<T: Default> From<&$small> for $name<T>
                where
                    $small: From<T>,
                {
                    fn from(r: &$small) -> Self {
                        Self::new(*r)
                    }
                }

                impl<T: Default> From<$name<T>> for $small
                where
                    $small: From<T>,
                {
                    fn from(m: $name<T>) -> Self {
                        m.r
                    }
                }

                impl<T: Default> Mul<Self> for $name<T>
                where
                    $small: From<T>,
                {
                    type Output = $name<T>;

                    fn mul(self, rhs: Self) -> Self::Output {
                        Self::new_unchecked(
                            (self.r as $big * rhs.r as $big % <$small>::from(T::default()) as $big)
                                as $small,
                        )
                    }
                }

                impl_ref_runtime_modulo_binary_op!($name, $small, Mul, mul);

                impl<T: Default> MulAssign<Self> for $name<T>
                where
                    $small: From<T>,
                {
                    fn mul_assign(&mut self, rhs: Self) {
                        *self = *self * rhs;
                    }
                }

                impl_ref_runtime_modulo_op_assign!($name, $small, MulAssign, mul_assign);

                impl<T: Default> Div<Self> for $name<T>
                where
                    $small: From<T>,
                {
                    type Output = $name<T>;

                    fn div(self, rhs: Self) -> Self::Output {
                        self * rhs.recip()
                    }
                }

                impl_ref_runtime_modulo_binary_op!($name, $small, Div, div);

                impl<T: Default> DivAssign<Self> for $name<T>
                where
                    $small: From<T>,
                {
                    fn div_assign(&mut self, rhs: Self) {
                        *self = *self / rhs;
                    }
                }

                impl_ref_runtime_modulo_op_assign!($name, $small, DivAssign, div_assign);

                impl<T: Default> AddAssign<Self> for $name<T>
                where
                    $small: From<T>,
                {
                    fn add_assign(&mut self, rhs: Self) {
                        let (tmp, flag) = self.r.overflowing_add(rhs.r);
                        let r#mod = <$small>::from(T::default());

                        self.r = if tmp >= r#mod || flag {
                            tmp.wrapping_sub(r#mod)
                        } else {
                            tmp
                        }
                    }
                }

                impl_ref_runtime_modulo_op_assign!($name, $small, AddAssign, add_assign);

                impl<T: Default> SubAssign<Self> for $name<T>
                where
                    $small: From<T>,
                {
                    fn sub_assign(&mut self, rhs: Self) {
                        if self.r < rhs.r {
                            self.r = self.r.wrapping_add(T::default().into());
                        }

                        self.r = self.r.wrapping_sub(rhs.r);
                    }
                }

                impl_ref_runtime_modulo_op_assign!($name, $small, SubAssign, sub_assign);

                impl<T: Default> Add for $name<T>
                where
                    $small: From<T>,
                {
                    type Output = Self;

                    fn add(mut self, rhs: Self) -> Self::Output {
                        self += rhs;

                        self
                    }
                }

                impl_ref_runtime_modulo_binary_op!($name, $small, Add, add);

                impl<T: Default> Sub for $name<T>
                where
                    $small: From<T>,
                {
                    type Output = Self;

                    fn sub(mut self, rhs: Self) -> Self::Output {
                        self -= rhs;

                        self
                    }
                }

                impl_ref_runtime_modulo_binary_op!($name, $small, Sub, sub);

                impl<T: Default> Neg for $name<T>
                where
                    $small: From<T>,
                {
                    type Output = Self;

                    fn neg(self) -> Self::Output {
                        if self.r == 0 {
                            self
                        } else {
                            Self::new_unchecked(<$small>::from(T::default()) - self.r)
                        }
                    }
                }

                impl<T: Default> Neg for &$name<T>
                where
                    $small: From<T>,
                {
                    type Output = $name<T>;

                    fn neg(self) -> Self::Output {
                        -*self
                    }
                }

                impl<T: Default> Sum for $name<T>
                where
                    $small: From<T>,
                {
                    fn sum<I: Iterator<Item = Self>>(iter: I) -> Self {
                        iter.fold(Self::new_unchecked(0), |a, b| a + b)
                    }
                }

                impl<T: Default> Product for $name<T>
                where
                    $small: From<T>,
                {
                    fn product<I: Iterator<Item = Self>>(iter: I) -> Self {
                        iter.fold(Self::new(1), |a, b| a * b)
                    }
                }

                impl<T: Default> Debug for $name<T>
                where
                    $small: From<T>,
                {
                    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
                        f.debug_tuple(
                            format!("{}<{}>", $name_str, <$small>::from(T::default())).as_str(),
                        )
                        .field(&self.r)
                        .finish()
                    }
                }

                impl<T: Default> Display for $name<T>
                where
                    $small: From<T>,
                {
                    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
                        std::fmt::Display::fmt(&self.r, f)
                    }
                }
            };
        }

        #[derive(Default, Eq, PartialEq, Hash)]
        pub struct RuntimeModulo8<T: Default>
        where
            u8: From<T>,
        {
            r: u8,
            _phantom: PhantomData<T>,
        }

        #[derive(Default, Eq, PartialEq, Hash)]
        pub struct RuntimeModulo16<T: Default>
        where
            u16: From<T>,
        {
            r: u16,
            _phantom: PhantomData<T>,
        }

        #[derive(Default, Eq, PartialEq, Hash)]
        pub struct RuntimeModulo32<T: Default>
        where
            u32: From<T>,
        {
            r: u32,
            _phantom: PhantomData<T>,
        }

        #[derive(Default, Eq, PartialEq, Hash)]
        pub struct RuntimeModulo64<T: Default>
        where
            u64: From<T>,
        {
            r: u64,
            _phantom: PhantomData<T>,
        }

        runtime_modulo!(RuntimeModulo8, u8, u16, "RuntimeModulo8");
        runtime_modulo!(RuntimeModulo16, u16, u32, "RuntimeModulo16");
        runtime_modulo!(RuntimeModulo32, u32, u64, "RuntimeModulo32");
        runtime_modulo!(RuntimeModulo64, u64, u128, "RuntimeModulo64");
    }

    use std::io::BufRead;
    use std::str::FromStr;

    pub trait Scanner {
        fn checked_next_line(&mut self) -> Option<String>;

        fn checked_next<T: FromStr>(&mut self) -> Option<T>;

        #[allow(dead_code)]
        fn next<T: FromStr>(&mut self) -> T;

        fn seek(&mut self) -> bool;
    }

    pub struct IOScanner<ReadType: BufRead> {
        read: ReadType,
        buffer: Vec<String>,
    }

    impl<ReadType: BufRead> Scanner for IOScanner<ReadType> {
        fn checked_next_line(&mut self) -> Option<String> {
            self.buffer.clear();
            let mut input = String::new();
            if self.read.read_line(&mut input).expect("Failed read") > 0 {
                Some(input)
            } else {
                None
            }
        }

        fn checked_next<T: FromStr>(&mut self) -> Option<T> {
            loop {
                if let Some(token) = self.buffer.pop() {
                    return Some(token.parse().ok().expect("Failed parse"));
                }
                if let Some(input) = self.checked_next_line() {
                    self.buffer = input.split_whitespace().rev().map(String::from).collect();
                } else {
                    return None;
                }
            }
        }

        fn next<T: FromStr>(&mut self) -> T {
            self.checked_next().expect("Read after EOF")
        }

        fn seek(&mut self) -> bool {
            let mut input = String::new();

            while let Ok(cnt) = self.read.read_line(&mut input) {
                if cnt == 0 {
                    break;
                }
                let line = input.trim();
                if !line.is_empty() && line.matches("=").count() == line.len() {
                    return true;
                }
                input.clear();
            }

            false
        }
    }

    impl<ReadType: BufRead> IOScanner<ReadType> {
        pub fn new(read: ReadType) -> IOScanner<ReadType> {
            IOScanner {
                read,
                buffer: Vec::<String>::default(),
            }
        }
    }
}
