#include <iostream>
#include <cmath>
#include <iomanip>
#include <cassert>
using namespace std;

long double dist(int x1, int y1, int x2, int y2) {
	return sqrtl((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
}

int dist_squared(int x1, int y1, int x2, int y2) {
	return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
}

struct Point {
	int x, y;
};

void solve() {
	int n;
	cin >> n;
	Point points[1000];
	for (int i = 0; i < n; ++i) {
		cin >> points[i].x >> points[i].y;
	}
	int p1 = -1;
	int p2 = -1;
	int max_dist_squared = 0;
	for (int i = 0; i < n; ++i) {
		for (int j = i + 1; j < n; ++j) {
			if (dist_squared(points[i].x, points[i].y, points[j].x, points[j].y) > max_dist_squared) {
				max_dist_squared = dist_squared(points[i].x, points[i].y, points[j].x, points[j].y);
				p1 = i;
				p2 = j;
			}
		}
	}
	assert(p1 != -1);
	int a = points[p1].x - points[p2].x;
	int b = points[p1].y - points[p2].y;
	/*
	a*x1 + b*y1 + c = 0
	c = -a*x1-b*y1
	*/
	int c1 = -a * points[p1].x - b * points[p1].y;
	int c2 = -a * points[p2].x - b * points[p2].y;
	cout << a << ' ' << b << ' ' << c1 << '\n';
	cout << a << ' ' << b << ' ' << c2 << '\n';
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	solve();
	return 0;
}