#include <iostream>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;

int find_min_shift(const vector<int>& arr) {
    int n = arr.size();
    if (n == 0) return 0;
    
    int i = 0, j = 1;
    while (j < n) {
        int k = 0;
        while (k < n && arr[(i + k) % n] == arr[(j + k) % n]) {
            k++;
        }
        if (k == n) break;
        if (arr[(i + k) % n] > arr[(j + k) % n]) {
            i = j;
            j++;
        } else {
            j += k + 1;
        }
        if (i > j) j = i + 1;
    }
    return i;
}

int first_run(int n, const vector<int>& arr) {
    int min_shift = find_min_shift(arr);
    return (min_shift + 1) % n + 1;
}

int second_run(int k, int total_players, const vector<int>& arr) {

    int k0 = k - 1;
    
    vector<bool> exists(total_players + 1, false);
    for (int num : arr) {
        exists[num] = true;
    }
    
    vector<int> missing;
    for (int i = 1; i <= total_players; i++) {
        if (!exists[i]) {
            missing.push_back(i);
        }
    }
    
    if (missing.size() == 1) {
        return missing[0];
    }
    
    for (int candidate : missing) {
        
        bool is_min = true;
        int n_total = total_players;

        for (int shift = 0; shift < n_total; shift++) {
            if (shift == k0) continue;
            
            bool less = false;
            bool equal = true;
            
            for (int pos = 0; pos < n_total; pos++) {
                int idx1 = (k0 + pos) % n_total;
                int idx2 = (shift + pos) % n_total;
                
                int val1, val2;

                if (idx1 < k0) val1 = arr[idx1];
                else if (idx1 == k0) val1 = candidate;
                else val1 = arr[idx1 - 1];
 
                if (idx2 < k0) val2 = arr[idx2];
                else if (idx2 == k0) val2 = candidate;
                else val2 = arr[idx2 - 1];
                
                if (val1 != val2) {
                    equal = false;
                    if (val1 > val2) {
                        less = false;
                        break;
                    } else {
                        less = true;
                        break;
                    }
                }
            }
            
            if (!equal && !less) {
                is_min = false;
                break;
            }
        }
        
        if (is_min) {
            return candidate;
        }
    }
    
    return missing[0];
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    string first_line;
    getline(cin, first_line);
    
    string second_line;
    getline(cin, second_line);
    
    string third_line;
    getline(cin, third_line);
    
    auto parse_numbers = [](const string& s) {
        vector<int> result;
        int num = 0;
        for (char c : s) {
            if (c == ' ') {
                if (num != 0) result.push_back(num);
                num = 0;
            } else {
                num = num * 10 + (c - '0');
            }
        }
        if (num != 0) result.push_back(num);
        return result;
    };
    
    if (first_line == "0") {
        int n = stoi(second_line);
        vector<int> arr = parse_numbers(third_line);
        int result = first_run(n, arr);
        cout << result << endl;
    } else {
        int k = stoi(first_line);
        int total_players = stoi(second_line);
        vector<int> arr = parse_numbers(third_line);
        int result = second_run(k, total_players, arr);
        cout << result << endl;
    }
    
    return 0;
}