﻿#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX = 3000005;

int fac[MAX], inv_fac[MAX], inv[MAX];

int mod_pow(int a, int b) {
    int res = 1;
    while (b) {
        if (b & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        b >>= 1;
    }
    return res;
}

void precompute() {
    fac[0] = 1;
    for (int i = 1; i < MAX; i++) {
        fac[i] = 1LL * fac[i - 1] * i % MOD;
    }
    inv_fac[MAX - 1] = mod_pow(fac[MAX - 1], MOD - 2);
    for (int i = MAX - 2; i >= 0; i--) {
        inv_fac[i] = 1LL * inv_fac[i + 1] * (i + 1) % MOD;
    }

    for (int i = 1; i < MAX; i++) {
        inv[i] = mod_pow(i, MOD - 2);
    }
}

int comb(int n, int k) {
    if (k < 0 || k > n) return 0;
    return 1LL * fac[n] * inv_fac[k] % MOD * inv_fac[n - k] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    precompute();
    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        int N = 2 * p + m;

        long long total = 0;

        int F0 = 1;
        int F1 = (2LL * p + m) % MOD;
        total = (total + 1LL * F0 * mod_pow(comb(N, 0), MOD - 2)) % MOD; 
        if (p + m >= 1) {
            total = (total + 1LL * F1 * mod_pow(comb(N, 1), MOD - 2)) % MOD;
        }
        int F_prev2 = F0;
        int F_prev1 = F1;
        for (int k = 2; k <= p + m; k++) {
            long long term1 = (2LL * p + m - 3LL * k + 3 + MOD) % MOD;
            long long term2 = (2LL * p + 2LL * m - 2LL * k + 4 + MOD) % MOD;

            int Fk = (term1 * F_prev1 + term2 * F_prev2) % MOD;
            Fk = 1LL * Fk * inv[k] % MOD;

            total = (total + 1LL * Fk * mod_pow(comb(N, k), MOD - 2)) % MOD;

            F_prev2 = F_prev1;
            F_prev1 = Fk;
        }
        cout << total % MOD << "\n";
    }
    return 0;
}