import java.util.*;
import java.io.*;

public class Main {
    public static void main(String[] args) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        StringTokenizer st = new StringTokenizer(reader.readLine());

        int n = Integer.parseInt(st.nextToken());
        long s = Long.parseLong(st.nextToken());

        final long MOD = 999983L;
        final long MULT = 618023L;

        Set<Long> V = new HashSet<>();
        // Кэш для быстрой проверки наличия числа
        boolean[] exists = new boolean[(int)MOD];

        int count = 0;
        for (int i = 0; i < n; i++) {
            s = (s * MULT + 1) % MOD;

            int pairs = 0;
            // Быстрая проверка с использованием массива
            for (long x : V) {
                long y = s - x;
                if (y >= 0 && y < MOD && exists[(int)y] && x <= y) {
                    pairs++;
                    // Если нашли много пар, можно выйти раньше
                    if (pairs > 100) break;
                }
            }

            if (pairs % 2 == 0) {
                V.add(s);
                exists[(int)s] = true;
                count++;
            }
        }

        System.out.println(count);
    }
}