#include <iostream>
#include <string>
#include <vector>
#include <climits>
using namespace std;

string can_play(const string& s) {
    vector<int> offset = { 0, 1, 2, 3, 4, 5, 6, 7 }; 
    offset['A' - 'A' + 1] = 1;
    offset['B' - 'A' + 1] = 2;
    offset['C' - 'A' + 1] = 3;
    offset['D' - 'A' + 1] = 4;
    offset['E' - 'A' + 1] = 5;
    offset['F' - 'A' + 1] = 6;
    offset['G' - 'A' + 1] = 7;

    int min_oct, max_oct;
    if (s[0] == 'A' || s[0] == 'B' || s[0] == 'C') {
        min_oct = 1;
        max_oct = 8;
    }
    else {
        min_oct = 1;
        max_oct = 7;
    }

    for (size_t i = 1; i < s.length(); i++) {
        char prev_ch = s[i - 1];
        char curr_ch = s[i];

        int curr_min, curr_max;
        if (curr_ch == 'A' || curr_ch == 'B' || curr_ch == 'C') {
            curr_min = 1;
            curr_max = 8;
        }
        else {
            curr_min = 1;
            curr_max = 7;
        }

        int new_min = INT_MAX;
        int new_max = INT_MIN;
        bool found = false;

        for (int curr_oct = curr_min; curr_oct <= curr_max; curr_oct++) {
            int curr_pos = (curr_oct - 1) * 7 + offset[curr_ch - 'A' + 1];

            for (int prev_oct = min_oct; prev_oct <= max_oct; prev_oct++) {
                int prev_pos = (prev_oct - 1) * 7 + offset[prev_ch - 'A' + 1];
                if (abs(curr_pos - prev_pos) <= 3) {
                    new_min = min(new_min, curr_oct);
                    new_max = max(new_max, curr_oct);
                    found = true;
                    break;
                }
            }
        }

        if (!found) {
            return "No";
        }

        min_oct = new_min;
        max_oct = new_max;
    }

    return "Yes";
}

int main() {
    int t;
    cin >> t;
    while (t--) {
        string s;
        cin >> s;
        cout << can_play(s) << endl;
    }
    return 0;
}