#include <iostream>
#include <vector>
#include <cmath>
#include <limits>

using namespace std;

int main() {
    int n;
    cin >> n;
    vector<pair<int, int>> points;

    for (int i = 0; i < n; i++) {
        int x, y;
        cin >> x >> y;
        points.push_back({ x, y });
    }

    double max_dist = -1;
    int best_a = 0, best_b = 0;
    int best_c1 = 0, best_c2 = 0;

    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            int x1 = points[i].first, y1 = points[i].second;
            int x2 = points[j].first, y2 = points[j].second;

            int a = x2 - x1;
            int b = y2 - y1;

            if (a == 0 && b == 0) {
                continue;
            }

            double min_proj = numeric_limits<double>::max();
            double max_proj = numeric_limits<double>::lowest();

            for (const auto& p : points) {
                int x = p.first, y = p.second;
                double proj = a * x + b * y;

                if (proj < min_proj) {
                    min_proj = proj;
                }
                if (proj > max_proj) {
                    max_proj = proj;
                }
            }

            double denominator = sqrt(a * a + b * b);
            double dist = (max_proj - min_proj) / denominator;

            if (dist > max_dist) {
                max_dist = dist;
                best_a = a;
                best_b = b;
                best_c1 = -min_proj;
                best_c2 = -max_proj;
            }
        }
    }

    cout << best_a << " " << best_b << " " << best_c1 << endl;
    cout << best_a << " " << best_b << " " << best_c2 << endl;

    return 0;
}