import sys
import random

def should_use_random(x):
    if x <= 1000:
        return False
    if (x & (x - 1)) == 0:
        return False
    if x % 3 == 1 and x > 10000:
        return random.random() < 0.4
    if x > 5 * 10**6:
        return random.random() < 0.2
    return False

def main():
    t = int(sys.stdin.readline().strip())
    
    for _ in range(t):
        x = int(sys.stdin.readline().strip())
        
        while True:
            if should_use_random(x):
                print("random")
            else:
                print("collatz")
            sys.stdout.flush()
            
            response = sys.stdin.readline().strip()
            if not response:
                break
                
            x = int(response)
            
            if x == 0:
                return
            if x == 1:
                break

if __name__ == "__main__":
    main()
