﻿#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

using namespace std;

void apply_L(int& x, int& y, int& z) {
    int new_x = -z;
    int new_y = -x;
    int new_z = -y;
    x = new_x;
    y = new_y;
    z = new_z;
}

void apply_R(int& x, int& y, int& z) {
    int new_x = -y;
    int new_y = -z;
    int new_z = -x;
    x = new_x;
    y = new_y;
    z = new_z;
}

void apply_T(int& x, int& y, int& z) {
    int new_x = z;
    int new_y = y;
    int new_z = x;
    x = new_x;
    y = new_y;
    z = new_z;
}

int main() {
    int n;
    cin >> n;
    vector<vector<int>> input(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        int count = (i < n) ? n + i : 3 * n - 2 - i;
        input[i].resize(count);
        for (int j = 0; j < count; j++) {
            cin >> input[i][j];
        }
    }

    string operations;
    cin >> operations;

    vector<vector<int>> output(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        int count = (i < n) ? n + i : 3 * n - 2 - i;
        output[i].resize(count);
        for (int j = 0; j < count; j++) {
            int y = i - (n - 1);
            int L = max(-(n - 1), -i);
            int x = L + j;
            int z = -x - y;

            for (int k = operations.size() - 1; k >= 0; k--) {
                char op = operations[k];
                if (op == 'L') {
                    apply_R(x, y, z);
                }
                else if (op == 'R') {
                    apply_L(x, y, z);
                }
                else if (op == 'T') {
                    apply_T(x, y, z);
                }
            }

            int i0 = y + (n - 1);
            int L0 = max(-(n - 1), -i0);
            int j0 = x - L0;
            output[i][j] = input[i0][j0];
        }
    }

    for (int i = 0; i < 2 * n - 1; i++) {
        for (int j = 0; j < output[i].size(); j++) {
            if (j > 0) {
                cout << " ";
            }
            cout << output[i][j];
        }
        cout << endl;
    }

    return 0;
}