﻿#include <iostream>
#include <string>

int get_mod4(const std::string& x) {
    int len = x.length();
    if (len == 0) return 0;

    int last_two_digits = 0;
    char last_digit = x.back();

    if (len >= 2) {
        last_two_digits = (x[len - 2] - '0') * 10 + (last_digit - '0');
    }
    else {
        last_two_digits = (last_digit - '0');
    }
    return last_two_digits % 4;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int t;
    std::cin >> t;

    for (int i = 0; i < t; ++i) {
        std::string x;
        std::cin >> x;

        while (x != "1") {
            if (x == "0") {
                return 0;
            }

            char last_digit = x.back();

            if (last_digit == '0' || last_digit == '2' || last_digit == '4' || last_digit == '6' || last_digit == '8') {
                std::cout << "collatz\n";
            }
            else {
                int mod4 = get_mod4(x);

                if (mod4 == 1) {
                    std::cout << "collatz\n";
                }
                else {
                    if (x.length() < 4) {
                        std::cout << "random\n";
                    }
                    else {
                        std::cout << "collatz\n";
                    }
                }
            }

            std::cout.flush();
            std::cin >> x;
        }
    }
    return 0;
}