﻿#include <stdio.h>

void print_u128(__uint128_t n) {
    if (n == 0) {
        putchar('0');
        return;
    }
    char buf[40];
    int i = 39;
    buf[i] = '\0';
    while (n > 0) {
        --i;
        buf[i] = (n % 10) + '0';
        n /= 10;
    }
    printf("%s", &buf[i]);
}

__uint128_t read_u128() {
    __uint128_t n = 0;
    char c;
    while ((c = getchar()) >= '0' && c <= '9') {
        n = n * 10 + (c - '0');
    }
    return n;
}

int main() {
    int t;
    scanf("%d", &t);

    for (int i = 0; i < t; ++i) {
        __uint128_t x = read_u128();

        while (x > 1) {
            printf("collatz\n");
            fflush(stdout);
            x = read_u128();

            if (x == 0) {
                return 0;
            }
        }
    }
    return 0;
}