#include <iostream>
#include <vector>
#include <cmath>
#include <tuple>
using namespace std;

struct Point {
    int x, y;
};

int main() {
    int n;
    cin >> n;
    vector<Point> pts(n);
    for (int i = 0; i < n; ++i) {
        cin >> pts[i].x >> pts[i].y;
    }

    double max_dist = -1;
    tuple<int, int, int> best1, best2;

    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            int a = pts[j].y - pts[i].y;
            int b = pts[i].x - pts[j].x;
            if (a < 0 || (a == 0 && b < 0)) {
                a = -a;
                b = -b;
            }
            int minv = a * pts[0].x + b * pts[0].y, maxv = minv;
            int imin = 0, imax = 0;
            for (int k = 1; k < n; ++k) {
                int v = a * pts[k].x + b * pts[k].y;
                if (v < minv) { minv = v; imin = k; }
                if (v > maxv) { maxv = v; imax = k; }
            }

            double dist = (maxv - minv) / sqrt(1.0 * a * a + 1.0 * b * b);
            if (dist > max_dist) {
                max_dist = dist;
                int c1 = -(a * pts[imin].x + b * pts[imin].y);
                int c2 = -(a * pts[imax].x + b * pts[imax].y);
                best1 = make_tuple(a, b, c1);
                best2 = make_tuple(a, b, c2);
            }
        }
    }

    auto print = [](const tuple<int, int, int>& t) {
        cout << get<0>(t) << " " << get<1>(t) << " " << get<2>(t) << "\n";
        };
    print(best1);
    print(best2);

    return 0;
}