﻿#include <iostream>
#include <vector>
#include <cstdint>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const int MOD = 999983;
    const int A = 618023;
    const int MAX_PAIR_SUM = 2 * MOD;

    int n;
    int s;
    cin >> n >> s;

    vector<uint8_t> present(MOD, 0);
    vector<uint8_t> pairParity(MAX_PAIR_SUM, 0);
    vector<int> elements;
    elements.reserve(n);

    for (int i = 0; i < n; ++i) {
        s = (int)(((long long)s * A + 1) % MOD);

        if (pairParity[s] == 0 && !present[s]) {
            present[s] = 1;
            elements.push_back(s);

            for (int a : elements) {
                pairParity[a + s] ^= 1;
            }
        }
    }

    cout << elements.size() << '\n';
    return 0;
}