#include <iostream>
using namespace std;

bool should_use_random(long long n) {
    // Используем random для нечетных чисел,
    // которые могут дать степень 2 в диапазоне [3n+1, 6n]
    if (n % 2 == 0) return false;
    
    long long min_r = 3LL * n + 1;
    long long max_r = 6LL * n;
    
    // Проверяем наличие степени 2 в диапазоне
    for (long long pow2 = 4; pow2 <= max_r; pow2 <<= 1) {
        if (pow2 >= min_r) {
            return true;
        }
    }
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int t;
    cin >> t;
    
    while (t--) {
        long long x;
        cin >> x;
        
        // Пытаемся использовать random один раз
        if (should_use_random(x)) {
            cout << "random" << endl;
            cout.flush();
            cin >> x;
            
            if (x == 0) return 0;
            if (x == 1) continue;
        }
        
        // Применяем collatz до достижения 1
        while (x > 1) {
            cout << "collatz" << endl;
            cout.flush();
            cin >> x;
            
            if (x == 0) return 0;
        }
    }
    
    return 0;
}