#include <iostream>
using namespace std;

bool is_power_of_two(long long n) {
    return (n & (n - 1)) == 0;
}

bool should_use_random(long long n) {
    if (n % 2 == 0) return false;
    
    __int128 min_r = (__int128)3 * n + 1;
    __int128 max_r = (__int128)6 * n;
    
    for (__int128 pow2 = 4; pow2 <= max_r && pow2 > 0; pow2 <<= 1) {
        if (pow2 >= min_r) {
            return true;
        }
    }
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int t;
    cin >> t;
    
    while (t--) {
        long long x;
        cin >> x;
        
        while (x > 1) {
            if (x % 2 == 0) {
                cout << "collatz" << endl;
            } else {
                if (should_use_random(x)) {
                    cout << "random" << endl;
                } else {
                    cout << "collatz" << endl;
                }
            }
            
            cout.flush();
            cin >> x;
            
            if (x == 0) return 0;
            if (x == 1) break;
        }
    }
    
    return 0;
}