#include <bits/stdc++.h>
using namespace std;

static inline int getbit(const vector<uint64_t>& A, int idx) {
    return (A[idx >> 6] >> (idx & 63)) & 1ULL;
}
static inline void setbit(vector<uint64_t>& A, int idx) {
    A[idx >> 6] |= (1ULL << (idx & 63));
}
static inline void xor_shift_left(vector<uint64_t>& dest,
                                  const vector<uint64_t>& src,
                                  int shift, int nbits) {
    const int W = (nbits + 63) >> 6;
    const int k = shift >> 6;
    const int o = shift & 63;
    if (o == 0) {
        for (int i = W - 1; i >= 0; --i) {
            uint64_t u = (i - k >= 0) ? src[i - k] : 0ULL;
            dest[i] ^= u;
        }
    } else {
        const int ro = 64 - o;
        for (int i = W - 1; i >= 0; --i) {
            uint64_t hi = (i - k >= 0) ? (src[i - k] << o) : 0ULL;
            uint64_t lo = (i - k - 1 >= 0) ? (src[i - k - 1] >> ro) : 0ULL;
            dest[i] ^= (hi | lo);
        }
    }
    int r = nbits & 63;
    if (r) dest[W - 1] &= ((r == 64) ? ~0ULL : ((1ULL << r) - 1));
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const int MOD = 999'983;
    const int A = 618'023;

    int n; long long s;
    if (!(cin >> n >> s)) return 0;

    const int W = (MOD + 63) >> 6;
    vector<uint64_t> B(W, 0), C1(W, 0); // presence and second bit of C mod 4
    int ans = 0;

    for (int i = 0; i < n; ++i) {
        s = (s * A + 1) % MOD;

        int diag = 0;
        if ((s & 1) == 0) diag = getbit(B, (int)(s >> 1));
        int off = getbit(C1, (int)s);
        int parity = diag ^ off;

        if (parity == 0 && !getbit(B, (int)s)) {
            xor_shift_left(C1, B, (int)s, MOD); // toggle second bit by +2 additions
            setbit(B, (int)s);
            ++ans;
        }
    }
    cout << ans << '\n';
    return 0;
}
