#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int MAXN = 2e6 + 5;

long long fact[MAXN], inv_fact[MAXN];

long long mod_pow(long long a, long long b) {
    long long res = 1;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAXN; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    inv_fact[MAXN - 1] = mod_pow(fact[MAXN - 1], MOD - 2);
    for (int i = MAXN - 2; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }
}

long long comb(int n, int k) {
    if (k < 0 || k > n) return 0;
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    precompute();
    
    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        
        long long total = 2 * p + m;
        long long numerator = 0;
        
        for (int k = 1; k <= p; k++) {
            long long ways = comb(p, k) * mod_pow(2, k) % MOD;
            ways = ways * fact[k - 1] % MOD;
            ways = ways * fact[total - k] % MOD;
            numerator = (numerator + ways * k) % MOD;
        }
        
        numerator = numerator * comb(total, p) % MOD;
        numerator = numerator * p % MOD;
        numerator = numerator * 2 % MOD;
        
        long long denominator = fact[total] * comb(total, p) % MOD;
        denominator = denominator * p % MOD;
        denominator = denominator * 2 % MOD;
        
        long long ans = numerator * mod_pow(denominator, MOD - 2) % MOD;
        cout << ans << "\n";
    }
    
    return 0;
}