MOD = 1_000_000_007

def modinv(x: int) -> int:
    return pow(x, MOD - 2, MOD)

def main():
    t = int(input().strip())
    pm = []
    max_p = 0
    for _ in range(t):
        p, m = map(int, input().split())
        pm.append((p, m))
        if p > max_p:
            max_p = p

    maxn = 2 * max_p + 1
    fact = [1] * (maxn + 1)
    for i in range(1, maxn + 1):
        fact[i] = fact[i - 1] * i % MOD
    invfact = [1] * (maxn + 1)
    invfact[maxn] = modinv(fact[maxn])
    for i in range(maxn, 0, -1):
        invfact[i - 1] = invfact[i] * i % MOD

    out = []
    for p, m in pm:
        top = (2 * p + m + 1) % MOD
        pow4 = pow(4, p, MOD)
        res = top
        res = res * pow4 % MOD
        res = res * fact[p] % MOD
        res = res * fact[p] % MOD
        res = res * invfact[2 * p + 1] % MOD
        out.append(str(res))

    print("\n".join(out))

if __name__ == "__main__":
    main()
