#include <iostream>
#include <string>
#include <vector>
#include <math.h>
#include <algorithm>
#include <tuple>

using namespace std;

long long int gcd(long long int a, long long int b)
{
    while (b != 0) {
        int temp = b;
        b = a % b;
        a = temp;
    }
    return a;
}
long long int lcm(long long int a, long long int b)
{
    return a * b / gcd(a, b);
}

struct Point 
{
    double x, y;

    Point(double x = 0, double y = 0) : x(x), y(y) {}

    Point operator - (const Point& p) const {
        return Point(x - p.x, y - p.y);
    }

    bool operator < (const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
};

double cross(const Point& a, const Point& b) {
    return a.x * b.y - a.y * b.x;
}

double cross(const Point& a, const Point& b, const Point& c) {
    return cross(b - a, c - a);
}

double dist2(const Point& a, const Point& b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

pair<Point, Point> farthestPoints(vector<Point> points) {
    int n = points.size();
    if (n <= 1) return { points[0], points[0] };

    // Строим выпуклую оболочку
    sort(points.begin(), points.end());

    vector<Point> hull;
    for (int i = 0; i < n; i++) {
        while (hull.size() >= 2 &&
            cross(hull[hull.size() - 2], hull.back(), points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }

    int lower_size = hull.size();
    for (int i = n - 2; i >= 0; i--) {
        while (hull.size() > lower_size &&
            cross(hull[hull.size() - 2], hull.back(), points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }
    hull.pop_back();

    // Вращающиеся калиперы
    n = hull.size();
    if (n == 1) return { hull[0], hull[0] };

    double max_dist2 = 0;
    pair<Point, Point> result;

    for (int i = 0, j = 1; i < n; i++) {
        while (true) {
            int next_j = (j + 1) % n;
            Point v1 = hull[(i + 1) % n] - hull[i];
            Point v2 = hull[next_j] - hull[j];

            if (cross(v1, v2) < 0) break;
            j = next_j;
        }

        double d2 = dist2(hull[i], hull[j]);
        if (d2 > max_dist2) {
            max_dist2 = d2;
            result = { hull[i], hull[j] };
        }
    }

    return result;
}
int main()
{
    int n,xi,yi;
    
    vector <int> xg(4), yg(4);

    cin >> n;
    vector<Point>points(n);
    
    /*cin >> xi >> yi;
    xg[0] = xi; xg[1] = xi;
    yg[2] = yi; yg[3] = yi;*/
    for (int i = 0; i < n; i++)
    {
        cin >> points[i].x >> points[i].y;
        
    }
    Point p1, p2;
    tie(p1, p2) = farthestPoints(points);
    double D;
    long int x1, x2, y1, y2;
    if (p1.x < p2.x)
    {
        x1 = p1.x; x2 = p2.x; y1 = p1.y; y2 = p2.y;
    }
    else
    {
        x2 = p1.x, x1 = p2.x, y2 = p1.y, y1 = p2.y;
    }
    long int dx = x2 - x1, dy = y2-y1;
    D = dx*dx + 4 * (dy - 1);
    double k1, k2, km;
    k1 = (-dx - sqrt(D)) / 2;
    k2 = (-dx + sqrt(D)) / 2;
    double d1 = abs(dy - k1 * dx) / sqrt(k1 * k1 + 1);
    double d2 = abs(dy - k2 * dx) / sqrt(k2 * k2 + 1);
    d1 > d2 ? km = k1 : km = k2;
    double cb1, cb2;
    cb1 = y1 - km * x1;
    cb2 = y2 - km * x2;

    long long int knorm = gcd(floor(abs(k1) * 1e9), 1e9),a1,b1,c1,a2,b2,c2,chk,zk,cb1n,cb2n;
    cb1n = gcd(floor(abs(cb1) * 1e9), 1e9);
    cb2n = gcd(floor(abs(cb2) * 1e9), 1e9);
    c1 = (long long int)floor(abs(cb1) * 1e9) / cb1n;
    c2 = (long long int)floor(abs(cb2) * 1e9) / cb2n;
    b1 = (long long int)1e9 / cb1n;
    b2 = (long long int)1e9 / cb2n;
    chk = (long long int)floor(abs(k1) * 1e9) / knorm;
    zk = (long long int)1e9 / knorm;
    b1 = lcm(b1, zk);
    a1 = -(long long int)km * b1;
    c1 = -(long long int)cb1 * b1;

    b2 = lcm(b2, zk);
    a2 = -(long long int)km * b2;
    c2 = -(long long int)cb2 * b2;
    cout << a1 << " " << b1 << " " << c1 << endl;
    cout << a2 << " " << b2 << " " << c2 << endl;
        //cout << k1 << " " << k2 << endl;
}