#include <bits/stdc++.h>
using namespace std;

struct HexSymmetry {
  int r;   // rotation ∈ [0..5]
  bool f;  // reflection flag

  HexSymmetry(int r = 0, bool f = false) : r((r % 6 + 6) % 6), f(f) {}

  HexSymmetry operator*(const HexSymmetry &o) const {
    int nr = (r + (f ? -o.r : o.r)) % 6;
    if (nr < 0) nr += 6;
    return HexSymmetry(nr, f ^ o.f);
  }

  static HexSymmetry R() { return HexSymmetry(1, false); }
  static HexSymmetry L() { return HexSymmetry(5, false); }
  static HexSymmetry T() { return HexSymmetry(0, true); }
};

template <typename T>
void transpose(vector<vector<T>> &mat) {
  int n = mat.size();
  for (int i = 0; i < n; i++) {
    for (int j = i + 1; j < n; j++) {
      swap(mat[i][j], mat[j][i]);
    }
  }
}

struct HexGrid {
  int n;
  vector<vector<int>> a;
  static constexpr int NONE = 432789412;

  HexGrid(int n = 0) : n(n), a(2 * n - 1) {
    for (auto &vec : a) {
      vec.resize(2 * n - 1, NONE);
    }
  }

  void read(istream &in = cin) {
    for (int i = 0; i < n; ++i) {
      for (int j = 0; j < n + i; ++j) {
        cin >> a[i][j];
      }
    }

    for (int i = 1; i < n; ++i) {
      int row = n - 1 + i;
      int len = n + n - i - 1;   
      int start = 2 * n - 1 - len; 
      for (int j = start; j < start + len; ++j) {
        cin >> a[row][j];
      }
    }
  }

  void print(ostream &out = cout) const {
    for (auto &row : a) {
      for (size_t j = 0; j < row.size(); ++j) {
        if (j) out << ' ';
        if (row[j] != NONE) out << row[j];
        // if (row[j] == NONE) out << '*';
      }
      out << '\n';
    }
  }

  void reflect() {
    for (int i = 0; i < n - 1; ++i) {
      int l = 0;
      int r = n - 1 + i;
      while (l < r) {
        std::swap(a[i][l], a[i][r]);
        l++;
        r--;
      }
    }
    for (int i = n - 1; i < 2 * n - 1; ++i) {
      int l = i - n + 1;
      int r = 2 * n - 2;
      while (l < r) {
        std::swap(a[i][l], a[i][r]);
        l++;
        r--;
      }
    }
  }

  void rotate60() {
    transpose(a);
    reflect();
  }

  void applySymmetry(HexSymmetry s) {
    for (int i = 0; i < s.r; ++i) {
      rotate60();
    }
    if (s.f) {
      reflect();
    }
  }
};

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);

  int n;
  if (!(cin >> n)) return 0;
  HexGrid hex(n);
  hex.read();

  string ops;
  cin >> ops;

  HexSymmetry cur;
  for (char c : ops) {
    if (c == 'R')
      cur = cur * HexSymmetry::R();
    else if (c == 'L')
      cur = cur * HexSymmetry::L();
    else if (c == 'T')
      cur = cur * HexSymmetry::T();
  }

  hex.applySymmetry(cur);
  hex.print();
}
