import sys

def solve_hex_operations():
    N = int(input().strip())

    grid = []
    for _ in range(2 * N - 1):
        row = list(map(int, input().strip().split()))
        grid.append(row)

    operations = input().strip()

    CENTER = N - 1

    def to_cube(r, c):
        z = r - CENTER
        x = c - CENTER + max(0, CENTER - r)
        y = -x - z
        return x, y, z

    def from_cube(x, y, z):
        r = z + CENTER
        c = x + CENTER - max(0, CENTER - r)
        return r, c

    # Matrices
    R_M = [[0, -1, 0], [0, 0, -1], [-1, 0, 0]]
    L_M = [[0, 0, -1], [-1, 0, 0], [0, -1, 0]]
    T_M = [[0, 0, 1], [0, 1, 0], [1, 0, 0]]
    I_M = [[1, 0, 0], [0, 1, 0], [0, 0, 1]]

    op_matrices = {'R': R_M, 'L': L_M, 'T': T_M}

    def multiply_matrices(A, B):
        C = [[0, 0, 0], [0, 0, 0], [0, 0, 0]]
        for i in range(3):
            for j in range(3):
                for k in range(3):
                    C[i][j] += A[i][k] * B[k][j]
        return C

    # Precompute the group
    from collections import deque
    matrix_to_tuple = lambda m: tuple(tuple(row) for row in m)
    group_set = set()
    group_set.add(matrix_to_tuple(I_M))
    queue = deque([I_M])
    while queue:
        current = queue.popleft()
        for op in 'LTR':
            new_m = multiply_matrices(op_matrices[op], current)
            new_t = matrix_to_tuple(new_m)
            if new_t not in group_set:
                group_set.add(new_t)
                queue.append(new_m)

    group_list = [list(list(row) for row in t) for t in group_set]
    num_elements = len(group_list)
    matrix_to_id = {matrix_to_tuple(m): idx for idx, m in enumerate(group_list)}

    # Precompute op_table: for each op, for each group id, the resulting id of op_mat * group_mat
    op_table = {}
    for op in 'LTR':
        op_mat = op_matrices[op]
        table = []
        for gid in range(num_elements):
            g_mat = group_list[gid]
            new_m = multiply_matrices(op_mat, g_mat)
            new_id = matrix_to_id[matrix_to_tuple(new_m)]
            table.append(new_id)
        op_table[op] = table

    # Now, compute the final transformation id
    current_id = matrix_to_id[matrix_to_tuple(I_M)]
    for op in operations:
        current_id = op_table[op][current_id]

    # Get the final matrix
    M_final = group_list[current_id]

    # The rest is the same
    final_cells = {}
    for r_orig in range(2 * N - 1):
        for c_orig, value in enumerate(grid[r_orig]):
            x_orig, y_orig, z_orig = to_cube(r_orig, c_orig)
            v_orig = [x_orig, y_orig, z_orig]

            v_final = [0, 0, 0]
            for i in range(3):
                for j in range(3):
                    v_final[i] += M_final[i][j] * v_orig[j]

            x_final, y_final, z_final = v_final
            r_final, c_final = from_cube(x_final, y_final, z_final)

            if r_final not in final_cells:
                final_cells[r_final] = []
            final_cells[r_final].append((c_final, value))

    output = []
    for r in range(2 * N - 1):
        if r in final_cells:
            final_cells[r].sort(key=lambda item: item[0])
            row_output = [str(item[1]) for item in final_cells[r]]
            output.append(" ".join(row_output))
        else:
            output.append("")

    while output and not output[-1]:
        output.pop()

    print("\n".join(output))


if __name__ == "__main__":
    solve_hex_operations()