#include <iostream>
#include <vector>
#include <string>
#include <cctype>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if (!(cin >> t)) return 0;

    const int M = 52;
    vector<char> key(M);
    for (int i = 0; i < M; ++i) key[i] = char('A' + (i % 7));

    while (t--) {
        string s;
        cin >> s;

        for (char &c : s) c = char(toupper((unsigned char)c));

        vector<int> prev(M, 0);
        for (int i = 0; i < M; ++i)
            if (key[i] == s[0]) prev[i] = 1;


        for (size_t pos = 1; pos < s.size(); ++pos) {
            
            vector<int> pref(M + 1, 0);
            for (int i = 0; i < M; ++i) pref[i + 1] = pref[i] + prev[i];

            vector<int> cur(M, 0);
            for (int i = 0; i < M; ++i) {
                if (key[i] != s[pos]) continue;
                int L = max(0, i - 3);
                int R = min(M - 1, i + 3);
                if (pref[R + 1] - pref[L] > 0) cur[i] = 1;
            }
            prev.swap(cur);
        }

        bool ok = false;
        for (int x : prev) if (x) { ok = true; break; }
        cout << (ok ? "Yes" : "No") << '\n';
    }

    return 0;
}