#include <iostream>
#include <algorithm>
using namespace std;

typedef long long ll;

const int MAXN = 1000;
ll x[MAXN], y[MAXN];

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    for (int i = 0; i < n; ++i) {
        cin >> x[i] >> y[i];
    }

    if (n == 1) {
        cout << "1 0 " << -x[0] << "\n1 0 " << -x[0] << '\n';
        return 0;
    }

    ll bestW = -1;
    ll bestA = 1, bestB = 0, bestC1 = 0, bestC2 = 0;

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            if (i == j) continue;
            ll a = x[j] - x[i];
            ll b = y[j] - y[i];

            ll minF = a * x[0] + b * y[0];
            ll maxF = minF;

            for (int k = 1; k < n; ++k) {
                ll f = a * x[k] + b * y[k];
                if (f < minF) minF = f;
                else if (f > maxF) maxF = f;
            }

            ll width = maxF - minF;
            if (width > bestW) {
                bestW = width;
                bestA = a;
                bestB = b;
                bestC1 = -minF;
                bestC2 = -maxF;
            }
        }
    }

    cout << bestA << ' ' << bestB << ' ' << bestC1 << '\n';
    cout << bestA << ' ' << bestB << ' ' << bestC2 << '\n';
    return 0;
}