#include <iostream>
#include <vector>

using namespace std;

const int MOD = 1000000007;
const int MAX_N = 3000005;

vector<int> fact(MAX_N);
vector<int> invFact(MAX_N);

int modPow(int a, int e, int mod) {
    int res = 1;
    while (e) {
        if (e & 1) res = (long long)res * a % mod;
        a = (long long)a * a % mod;
        e >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAX_N; i++) {
        fact[i] = (long long)fact[i - 1] * i % MOD;
    }
    invFact[MAX_N - 1] = modPow(fact[MAX_N - 1], MOD - 2, MOD);
    for (int i = MAX_N - 2; i >= 0; i--) {
        invFact[i] = (long long)invFact[i + 1] * (i + 1) % MOD;
    }
}

int solve(int p, int m) {
    int N = 2 * p + m;
    int T = p + m;

    vector<int> c(T + 1);
    c[0] = 1;
    if (T >= 1) {
        c[1] = (2LL * p + m) % MOD;
    }

    for (int k = 2; k <= T; k++) {
        long long term1 = (2LL * p + m - 3LL * k + 3 + MOD) % MOD;
        term1 = term1 * c[k - 1] % MOD;

        long long term2 = (2LL * p + 2LL * m - 2LL * k + 4 + MOD) % MOD;
        term2 = term2 * c[k - 2] % MOD;

        c[k] = (term1 + term2) % MOD;
        c[k] = (long long)c[k] * modPow(k, MOD - 2, MOD) % MOD;
    }

    long long sum = 0;
    for (int k = 0; k <= T; k++) {
        sum = (sum + (long long)fact[N - k] * fact[k] % MOD * c[k]) % MOD;
    }

    return sum * invFact[N] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    precompute();

    int t;
    cin >> t;

    vector<pair<int, int>> tests(t);
    vector<int> answers(t);

    //   
    for (int i = 0; i < t; i++) {
        cin >> tests[i].first >> tests[i].second;
    }

    //   
    for (int i = 0; i < t; i++) {
        answers[i] = solve(tests[i].first, tests[i].second);
    }

    //   
    for (int i = 0; i < t; i++) {
        cout << answers[i] << '\n';
    }

    return 0;
}