#include <iostream>
#include <array>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    // построим ряд букв для 52 клавиш
    string rows = "ABCDEFG";
    array<unsigned long long, 7> mask{};
    for (int i = 0; i < 52; ++i)
        mask[ rows[i % 7] - 'A' ] |= (1ULL << i);
    const unsigned long long FULL = (52 == 64 ? ~0ULL : ((1ULL << 52) - 1));

    int T; cin >> T;
    while (T--) {
        string s; cin >> s;
        unsigned long long reach = mask[s[0]-'A'];
        bool ok = true;
        for (size_t k = 1; k < s.size(); ++k) {
            unsigned long long spread = reach |
                (reach << 1) | (reach >> 1) |
                (reach << 2) | (reach >> 2) |
                (reach << 3) | (reach >> 3);
            spread &= FULL;
            reach = spread & mask[s[k]-'A'];
            if (!reach) { ok = false; break; }
        }
        cout << (ok && reach ? "Yes\n" : "No\n");
    }
    return 0;
}
