
import sys
import random
import time

random.seed(time.time() ^ (id(sys) << 16))

def random_case(s: str) -> str:

    r = random.random()
    if r < 0.12:
        return s.lower()
    if r < 0.24:
        return s.upper()

    return ''.join(ch.upper() if random.random() < 0.5 else ch.lower() for ch in s)

def safe_readline():
    line = sys.stdin.readline()
    if line == '':

        sys.exit(0)
    return line

def main():

    line = safe_readline().strip()
    if not line:
        sys.exit(0)
    try:
        t = int(line)
    except:

        sys.exit(0)
    for _ in range(t):
        while True:
            line = safe_readline().strip()
            if not line:
                sys.exit(0)
            try:
                x = int(line)
            except:
                sys.exit(0)
            if x == 0:
                sys.exit(0)
            if x == 1:

                break
            if random.random() < 0.90:
                out = random_case("collatz")
            else:
                out = random_case("random")
            print(out)
            sys.stdout.flush()

if __name__ == "__main__":
    main()
