def can_play(melody):
    positions = {
        'A': [0, 7, 14, 21, 28, 35, 42, 49],
        'B': [1, 8, 15, 22, 29, 36, 43, 50],
        'C': [2, 9, 16, 23, 30, 37, 44, 51],
        'D': [3, 10, 17, 24, 31, 38, 45],
        'E': [4, 11, 18, 25, 32, 39, 46],
        'F': [5, 12, 19, 26, 33, 40, 47],
        'G': [6, 13, 20, 27, 34, 41, 48]
    }

    current_positions = set(positions[melody[0]])

    for note in melody[1:]:
        next_positions = set()
        for pos in current_positions:
            for candidate in positions[note]:
                if abs(candidate - pos) <= 3:
                    next_positions.add(candidate)
        if not next_positions:
            return False
        current_positions = next_positions
    return True


t = int(input())
for _ in range(t):
    s = input().strip()
    print("Yes" if can_play(s) else "No")