import sys
data = sys.stdin.read().splitlines()
t = int(data[0])
keys_for_letter = {
    'A': [0, 7, 14, 21, 28, 35, 42, 49],
    'B': [1, 8, 15, 22, 29, 36, 43, 50],
    'C': [2, 9, 16, 23, 30, 37, 44, 51],
    'D': [3, 10, 17, 24, 31, 38, 45],
    'E': [4, 11, 18, 25, 32, 39, 46],
    'F': [5, 12, 19, 26, 33, 40, 47],
    'G': [6, 13, 20, 27, 34, 41, 48]
}
out_lines = []
for i in range(1, t + 1):
    melody = data[i].strip()
    if not melody:
        out_lines.append("Yes")
        continue
    current_set = set(keys_for_letter[melody[0]])
    for j in range(1, len(melody)):
        next_set = set()
        for prev_key in current_set:
            for curr_key in keys_for_letter[melody[j]]:
                if abs(prev_key - curr_key) <= 3:
                    next_set.add(curr_key)
        if not next_set:
            out_lines.append("No")
            break
        current_set = next_set
    else:
        out_lines.append("Yes")
sys.stdout.write("\n".join(out_lines))