﻿#include <iostream>
#include <vector>
#include <map>
#include <set>
#include <cmath>
#include <string>
using namespace std;

int main() {
    string letters = "ABCDEFG";
    map<char, vector<int>> keys;

    for (int i = 0; i < (int)letters.size(); ++i) {
        vector<int> positions;
        for (int j = 0; j < 52; ++j) {
            if (j % 7 == i)
                positions.push_back(j);
        }
        keys[letters[i]] = positions;
    }

    int t;
    cin >> t;
    while (t--) {
        string s;
        cin >> s;

        set<int> cur(keys[s[0]].begin(), keys[s[0]].end());
        bool ok = true;

        for (size_t i = 1; i < s.size(); ++i) {
            set<int> next_keys;
            for (int k : keys[s[i]]) {
                for (int prev : cur) {
                    if (abs(k - prev) <= 3) {
                        next_keys.insert(k);
                        break;
                    }
                }
            }

            if (next_keys.empty()) {
                ok = false;
                break;
            }

            cur = next_keys;
        }

        cout << (ok ? "Yes" : "No") << endl;
    }

    return 0;
}
