package org.example

lateinit var originalArray: IntArray
var minGlobal = 0L
var maxGlobal = 0L

fun main() {
    val len = readln().toInt()
    val arr: IntArray = readln().split(" ").map { it.toInt() }.toIntArray()
    minGlobal = Long.MAX_VALUE
    maxGlobal = 0
    originalArray = arr
    rec(arr, len - 1)
    println("$minGlobal $maxGlobal")
}

fun rec(arr: IntArray, n: Int) {
    if (n < 0) {
        return
    }

    val current = resForArray(arr, originalArray)
    if (current > 0) {
        minGlobal = minOf(minGlobal, current)
        maxGlobal = maxOf(maxGlobal, current)
    }
    val arrWithoutCurrent = fillWithout(arr, n, arr.size)
    rec(arr, n - 1)
    rec(arrWithoutCurrent, n - 1)
}

fun resForArray(arr: IntArray, orig: IntArray): Long {
    var inSum = 0L
    var outSum = 0L
    for (i in orig.indices) {
        if (i < arr.size && originalArray[i] in arr) {
            inSum += orig[i]
        } else {
            outSum += orig[i]
        }
    }

    return inSum * outSum
}

fun fillWithout(arr: IntArray, n: Int, size: Int): IntArray {
    val newArr = IntArray(size - 1)
    for (i in arr.indices) {
        if (i == n) {
            continue
        }
        if (i < n) {
            newArr[i] = arr[i]
        } else {
            newArr[i - 1] = arr[i]
        }
    }
    return newArr
}