// #pragma GCC optimize ("O3")
#include <bits/stdc++.h>
using  ll = long long;
using ull = unsigned long long;
using  ld = long double;
// #define int ll
using namespace ::std;
#define forn(i, n) for (ll i = 0; i < (n); ++i)
#define forr(i, n) for (ll i = (n) - 1; i >= 0; --i)
#define fore(collection) for (auto& val : (collection))
#define all(v) v.begin(), v.end()
#define rall(v) v.rbegin(), v.rend()
#define cmax(u, v) u = max(u, v)
#define cmin(u, v) u = min(u, v)
using vi    = vector<int>;
using vvi   = vector<vi>;
using vll   = vector<ll>;
using vvll  = vector<vll>;
using pii   = pair<int, int>;
using pll   = pair<ll, ll>;
template<typename ValueType>
istream& operator>>(istream& in, vector<ValueType>& vect) { fore(vect) in >> val; return in; }
template<typename ValueType>
ostream& operator<<(ostream& out, const vector<ValueType>& vect) { fore(vect) out << val << " "; return out; }


template<size_t MOD_P>
class BaseModInt;

template<size_t MOD_P>
static const BaseModInt<MOD_P> moduloPow(BaseModInt<MOD_P> x, size_t p) {
    if (p == 0)
        return 1;
    if (p & 1)
        return moduloPow(x, p - 1) * x;
    return moduloPow(x * x, p / 2);
}

template<size_t MOD_P>
class BaseModInt {
public:
    BaseModInt(ll x = 0) : x_((x + 1ull * MOD_P * MOD_P) % MOD_P) {}

    void operator+=(const BaseModInt& rhs) noexcept {
        x_ += rhs.x_;
        x_ %= MOD_P;
    }

    void operator-=(const BaseModInt& rhs) noexcept {
        x_ += MOD_P - rhs.x_;
        x_ %= MOD_P;
    }

    void operator*=(const BaseModInt& rhs) noexcept {
        x_ = ll(x_) * rhs.x_ % MOD_P;
    }

    void operator/=(const BaseModInt& rhs) noexcept {
        x_ = ll(x_) * moduloPow(rhs, MOD_P - 2).x_ % MOD_P;
    }

    explicit operator int() const noexcept {
        return x_;
    }

    template<size_t P>
    friend const BaseModInt<P> operator+(const BaseModInt<P>&, const BaseModInt<P>&) noexcept;
    template<size_t P>
    friend const BaseModInt<P> operator-(const BaseModInt<P>&, const BaseModInt<P>&) noexcept;
    template<size_t P>
    friend const BaseModInt<P> operator*(const BaseModInt<P>&, const BaseModInt<P>&) noexcept;
    template<size_t P>
    friend const BaseModInt<P> operator/(const BaseModInt<P>&, const BaseModInt<P>&) noexcept;
private:
    int x_;
};

template<size_t MOD_P>
const BaseModInt<MOD_P> operator+(const BaseModInt<MOD_P>& lhs, const BaseModInt<MOD_P>& rhs) noexcept {
    return (lhs.x_ + rhs.x_) % MOD_P;
}

template<size_t MOD_P>
const BaseModInt<MOD_P> operator-(const BaseModInt<MOD_P>& lhs, const BaseModInt<MOD_P>& rhs) noexcept {
    return (lhs.x_ - rhs.x_ + MOD_P) % MOD_P;
}

template<size_t MOD_P>
const BaseModInt<MOD_P> operator*(const BaseModInt<MOD_P>& lhs, const BaseModInt<MOD_P>& rhs) noexcept {
    return (ll(lhs.x_) * rhs.x_) % MOD_P;
}

template<size_t MOD_P>
const BaseModInt<MOD_P> operator/(const BaseModInt<MOD_P>& lhs, const BaseModInt<MOD_P>& rhs) noexcept {
    return ll(lhs.x_) * moduloPow(rhs, MOD_P - 2).x_ % MOD_P;
}

template<size_t MOD_P>
istream& operator>>(istream& in, BaseModInt<MOD_P>& val) {
    int x;
    cin >> x;
    val = x;
    return in;
}

template<size_t MOD_P>
ostream& operator<<(ostream& in, const BaseModInt<MOD_P>& val) {
    cout << int(val);
    return in;
}

constexpr int MOD = 1e9+7;
using ModInt = BaseModInt<MOD>;
using vmod = vector<ModInt>;
using vvmod = vector<vmod>;

ModInt f(ModInt p, ModInt n) {
    if (int(p) == 0) {
        return 1;
    }
    return f(p - ModInt(1), n) * ModInt(2) * p / n + ModInt(1);
}

ModInt E(ModInt p, ModInt m) {
    if (int(m) == 0)
        return 1;
    return E(p, m - ModInt(1)) * (ModInt(1) + ModInt(1) / (ModInt(2) * p + ModInt(1)));
}

void doWork() {
    ModInt p, m;
    cin >> p >> m;
    cout << E(p, m) * f(p, ModInt(2) * p) << endl;
}

signed main() {
    srand(chrono::duration_cast<chrono::nanoseconds>(chrono::steady_clock::now().time_since_epoch()).count());
    ios_base::sync_with_stdio(false);
    size_t t = 1;
    cin >> t;
    while (t--) {
        try {
            doWork();
        }
        catch(const std::exception& e) {
            std::cerr << e.what() << '\n';
            return 1;
        }
    }
    return 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ..................................................................................................................  //
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ... //
//  .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. . . //
// . .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .  //
// .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ...  //
// .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. . .. //
//  .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. . . //
//   .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  . .   //
// .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  . .  //
// .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. . :. //
//   .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  ..:   //
// .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  :  : //
//  .  .  .  .  .  .  .  .  .  .  .  .  .  . .:@@  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  . ..  .  .  .  . .  :: //
//  .  .  .  .  .  .  .  .  .  .  .  .  .  . @:::::=.  .  .  .  .  .  .  .  .  .  .  .  .  .  .  ---.  .  .  ..:  .::: //
//   .  .  .  .  .  .  .  .  .  .  .  .  .  . @::::::# .  .  .  .  .  .  .  .  .  .  .  .  . . - --  .  .  . .:  ::::: //
// .  .  .  .  .  . .  .  .  .  .  .  .  .. .  @:::::%  . *:@ .  .  .  .  .  .  .  .  .  .  ....---..........:  :::::: //
//  .  .  .  .  .  ++ .  .  .  .  .  .  . +@= .  @@:@@::@@::@  . .+    .....................: ----........... :::::::: //
//   .  .  .  .  .+..+  .  .  .  .  :  . .:::@ =:::++++%@::@@....=.+.....:=................- -----........:  ::::::::: //
//   .  ..........+...:.............+:+..++@:@@@@@:%@@@@::::::@.....+...:.+..............-- ------.......: .:::::::::: //
// ...............+...........:=...@@::::=@@.:::::::=@::*::::::@+...=+....=..........  ::- -------......: :::::::::::: //
// ...............+.+..--....+.+....@#:::::::@@:::::::@::@:::::@:%@..+....:=@....:+.  .:- ---------...::.::::::::::::: //
// ...............+..+=.=...=..=....::@:::::::@::@:::::@:@=@::::::::@.+%-....#..+.+::::------------..::::::::::::::::: //
// ............+:..+..+.=..=...+:=+:@*%#@::::::@:@=@@@@@:@::@++++@:::@+@.....@@...:===--------------:::::::::::::::::: //
// .....+:+=...+.+..+..+...:....+..@::::::@@:=@%@%:@++++::@@++++++@::@%:@*-:#@..=.=.==---------------::::::::::::::::: //
// ...........+:+.:..+.+..+:......@::::::::::@+++*:@+@@@:::@+@:::::::@::::@=.-....+..-----------------:::::::::::::::: //
// .............+..+.........:....@::::::::::@+++*@::::::::@:::::::::@%@+==..+..:..:-------------------::::::::::::::: //
// .........:....:..-+......=.....::=%::@:::::@@@@@::::::::@::::::::@...............--------------------:::::::::::::: //
// ...............+...++.+........+@::::@:::::::::@:::::::::::::::+@...............---------------------::::::::::::.  //
// ...............................@::::::::::::::@::::::::@@@@@@@%.................---------------------:::::::::::    //
// ................................@::::::::::::@:::::::+@........................:---------------------::::::::::     //
// .................................:@@::::::@@.@@@@@@@..............................-------------------...::::::      //
// ..............................................................................................................      //
// ..............................................................................................................      //
// ...............................................................................................................     //
// ........................................................:::....................................................     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
