#include <iostream>
#include <vector>
#include <algorithm>

struct Matrix
{
    int n_;
    std::vector<std::vector<int>> m;

    Matrix(std::vector<std::vector<int>> values)
        : m(values)
    {
        n_ = (m.size() + 1) / 2;
    }

    Matrix(const std::vector<int> &v, int n)
    {
        n_ = n;
        const auto rows = 2 * n - 1;
        const auto cols = 4 * n - 3;
        std::size_t offset = 0;
        m.resize(rows);
        for (std::size_t r = 0; r < rows; ++r)
        {
            m[r].resize(cols);
        }

        for (std::size_t r = 0; r < rows; ++r)
        {
            std::size_t align = n > r ? n - r - 1 : r - n + 1;
            for (std::size_t c = 0; c < align; ++c)
            {
                m[r][c] = -1;
            }
            for (std::size_t c = align, k = 0; c + align < cols; ++c, ++k)
            {
                if (k % 2 == 0)
                {
                    m[r][c] = v[offset];
                    ++offset;
                }
                else
                {
                    m[r][c] = -1;
                }
            }
            for (std::size_t c = cols - align; c < cols; ++c)
            {
                m[r][c] = -1;
            }
        }
    }

    void rightDiag(int r, int c, std::vector<int> &values) const
    {
        int tr = r;
        int tc = c;
        while (tr < m.size() && tc < m[0].size())
        {
            if (m[tr][tc] == -1)
            {
                return;
            }
            values.push_back(m[tr][tc]);
            ++tr;
            ++tc;
        }
    }

    void leftDiag(int r, int c, std::vector<int> &values) const
    {
        int tr = r;
        int tc = c;
        while (tr >= 0 && tc < m[0].size())
        {
            if (m[tr][tc] == -1)
            {
                return;
            }
            values.push_back(m[tr][tc]);
            --tr;
            ++tc;
        }
    }

    bool isValid(int r, int c) const
    {
        if (r < 0 || r >= m.size())
        {
            return false;
        }
        if (c < 0 || c >= m[0].size())
        {
            return false;
        }
        return true;
    }

    Matrix L() const
    {
        std::vector<int> values;

        int r = 0;
        int c = m[0].size() - 1;
        while (m[r][c] == -1)
        {
            --c;
        }

        while (isValid(r, c))
        {
            rightDiag(r, c, values);
            if (c - 2 > 0 && r == 0 && m[0][c - 2] != -1)
            {
                c = c - 2;
            }
            else
            {
                c -= 1;
                r += 1;
            }
        }

        return Matrix(values, n_);
    }

    Matrix R() const
    {
        std::vector<int> values;

        int r = 0;
        int c = 0;
        while (m[r][c] == -1)
        {
            ++r;
        }

        while (isValid(r, c))
        {
            leftDiag(r, c, values);
            if (r + 1 < m.size())
            {
                r += 1;
                c += 1;
            }
            else
            {
                c += 2;
            }
        }

        return Matrix(values, n_);
    }

    Matrix T() const
    {
        std::vector<std::vector<int>> copy = m;
        for (auto &row : copy)
        {
            std::reverse(row.begin(), row.end());
        }
        return Matrix(copy);
    }

    void print() const
    {
        for (const auto &row : m)
        {
            for (const auto &c : row)
            {
                if (c == -1)
                {
                    std::cout << ' ';
                    continue;
                }
                std::cout << c;
            }
            std::cout << '\n';
        }
    }
};

int main()
{
    int n;
    std::cin >> n;

    int total = 0;
    int k = n;
    for (int i = 0; i + 1 < n; ++i)
    {
        total += k;
        ++k;
    }
    total *= 2;
    total += 2 * n - 1;

    std::vector<int> arr(total);
    for (auto &v : arr)
    {
        std::cin >> v;
    }

    Matrix m(arr, n);

    std::string transforms;
    std::cin >> transforms;
    int cl = 0;
    bool tf = false;
    for (const auto &transform : transforms)
    {
        if (transform == 'T')
        {
            tf = !tf;
        }
        if (transform == 'L')
        {
            if (!tf)
            {
                ++cl;
            }
            else
            {
                --cl;
            }
        }
        if (transform == 'R')
        {
            if (!tf)
            {
                --cl;
            }
            {
                ++cl;
            }
        }

        cl = (cl + 6) % 6;
    }

    while (cl--)
    {
        auto tmp = m.L();
        m = std::move(tmp);
    }
    if (tf)
    {
        m = m.T();
    }
    m.print();
    return 0;
}
