#include <iostream>
#include <vector>
#include <climits>
#include <algorithm>
#include <map>
#include <numeric>
#include <math.h>
#include <cmath>
#include <unordered_map>
#include <string>
#include <stack>
#include <queue>
#include <iomanip>
#include <set>
using namespace std;

using ll = long long;
using ld = long double;

const int N = 10000005;

ll collatz(ll a) {
    if (a & 1) {
        return a * 3 + 1;
    }
    return a >> 1;
}

int calc(ll a) {
    int cnt = 0;
    while (a < (1 << 30) && a > 1 && cnt < 50) {
        a = collatz(a);
        cnt++;
    }
    if (a >= (1 << 30) || cnt >= 50) {
        return 1000;
    }
    return cnt;
}

void solve() {
    int x0;
    cin >> x0;
    int steps = 0;
    while (true) {
        int cc = calc(x0);
        if (cc < 100 - steps) {
            std::cout << "collatz" << endl;
        } else {
            if (x0 > (1 << 30)) {
                std::cout << "collatz" << endl;
            } else {
                std::cout << "random" << endl;
            }
        }
        cin >> x0;
        if (x0 == 0) {
            break;
        }
        if (x0 == 1) {
           break;
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout << setprecision(15);
    ll t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}