import java.math.BigInteger;
import java.util.Scanner;

public class Program {
	public static int len10(BigInteger x) {
		int k = 0;
		while (x.compareTo(BigInteger.ZERO) != 0) {
			k++;
			x = x.divide(BigInteger.TEN);
		}
		return k;
	}

	public static BigInteger collatz(BigInteger x) {
		if (x.testBit(0))
			return x.multiply(BigInteger.valueOf(3)).add(BigInteger.ONE);
		return x.shiftRight(1);
	}

	public static int calc(BigInteger x) {
		int q = 0;
		while (x.compareTo(BigInteger.ONE) != 0) {
			q += len10(x);
			x = collatz(x);
		}
		return q;
	}

	public static void main(String[] args) {
		var scanner = new Scanner(System.in);
		var t = scanner.nextInt();
		int totalrem = 30000;
		for (int i = 0; i < t; ++i) {
			int rem = totalrem / (t - i) + (x - 10000000 / 2) / 120;
			BigInteger x;
			x = BigInteger.valueOf(scanner.nextInt());
			int state = 0;
			while (x.compareTo(BigInteger.ONE) == 1) {
				if (state == -1 || (x.testBit(0) == false || x.testBit(1) == false)) {
					System.out.println("collatz");
				} else if (state == 0) {
					int cur = calc(x);
					if (cur > rem) {
						System.out.println("random");
					} else {
						state = -1;
						System.out.println("collatz");
					}
				}
				var nx = new BigInteger(scanner.next());
				if (nx.compareTo(BigInteger.ZERO) == 0) {
					return;
				}
				x = nx;
				rem -= len10(x);
				totalrem -= len10(x);
			}
		}
	}
}