from sys import stdout

t = int(input())

def collatz(x):
    return x // 2 if x % 2 == 0 else 3 * x + 1

def calc_collatz(n, limit):
    cur = n
    res = 0
    while cur > 1:
        if res > limit:
            return False, res
        res += len(str(cur))
        cur = collatz(cur)
    return True, res

def calc_collatz_k(n, k):
    cur = n
    res = 0
    for _ in range(k):
        res += len(str(cur))
        cur = collatz(cur)
        if cur == 1: return res, cur
    return res, cur

def decrease_digits(val, times):
    records = []
    cnt = 0
    k = 0
    for _ in range(times):
        if len(records) == 0 or val < records[-1][0]:
            records.append([val, k])
        if value == 1: break
        k += 1
        cnt += len(str(val))
        val = collatz(val)
    return records[-1][1]

def push_collatz(val):
    cnt = 0
    while val != 1:
        cnt += len(str(val))
        val = ask("collatz")
    return cnt

def drop_collatz(val):
    cnt = 0
    while val % 2 == 0:
        cnt += len(str(val))
        val = ask("collatz")
    return val, cnt

def ask(s):
    print(s)
    stdout.flush()
    if (response := int(input())) == 0: assert False
    return response

DECREASE_ORDER = 10
DECREASE_VICTIM = 50
TIMES = 4

curcnt = 0
for i in range(t):
    curcnt += 600
    value = int(input())

    while value != 1:
        drop = drop_collatz(value)
        value = drop[0]
        curcnt -= drop[1]

        decrease_idea = decrease_digits(value, TIMES)

        if decrease_idea > 0:
            clc = calc_collatz_k(value, decrease_idea)
            value = clc[0]
            curcnt -= clc[1]

        if (clc := calc_collatz(value, curcnt))[0] is True:
            value = 1
            curcnt -= push_collatz("collatz")
        else:
            curcnt -= len(str(value))
            result = ask("random")
            value = result