#pragma GCC optimize ("O3")
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <deque>

using namespace std;
using ll = long long;
using ld = long double;
const ll MAXSZ = 6e7+10;
const ll MAXN = 6e7;
vector<int> cointatz(MAXSZ);
vector<bool> bad(MAXSZ);
int f_cointatz(int n) {
    if (cointatz[n] != 0) {
        return cointatz[n];
    }
    if (n % 2 == 0) {
        if (bad[n / 2]) {
            cointatz[n] = 707;
        }
        else {
            cointatz[n] = to_string(n).size() + f_cointatz(n / 2);
        }
    }
    else if(3*n + 1 < MAXSZ){
        if(bad[n * 3 + 1]){
            cointatz[n] = 707;
        }
        else {
            cointatz[n] = to_string(n).size() + f_cointatz(3 * n + 1);
        }
    }
    else {
        bad[n] = true;
        cointatz[n] = 707;
    }
    return cointatz[n];
}
vector<pair<int, int>>tree(4 * MAXN);
void build(int v, int vl, int vr) {
    if (vl == vr - 1) {
        tree[v] = { cointatz[vl], 1};
        return;
    }
    int vm = (vl + vr) / 2;
    build(v * 2, vl, vm);
    build(v * 2 + 1, vm, vr);
    tree[v].first = tree[v * 2].first + tree[v * 2 + 1].first;
    tree[v].second = tree[v * 2].second + tree[v * 2 + 1].second;
}
pair<int, int> get(int v, int vl, int vr, int ql, int qr) {
    if (vl == ql && vr == qr) {
        return tree[v];
    }
    int vm = (vl + vr) / 2;
    if (qr <= vm) {
        return get(v * 2, vl, vm, ql, qr);
    }
    else if (ql >= vm) {
        return get(v * 2 + 1, vm, vr, ql, qr);
    }
    else {
        pair<int, int>L = get(v * 2, vl, vm, ql, vm);
        pair<int, int>R = get(v * 2 + 1, vm, vr, vm, qr);
        return { L.first + R.first, L.second + R.second };
    }
}
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0), cout.tie(0);
    cointatz[1] = 1;
    for (int i = 2; i <= MAXN; i++) {
        f_cointatz(i);
    }
    build(1, 0, MAXN);
    int t;
    cin >> t;
    while (t--) {
        int x;
        cin >> x;
        while (x != 1) {
            pair<int, int> expect = get(1, 0, MAXN, 3 * x + 1, 6 * x + 1);
            ld ex = (ld)expect.first / (ld)expect.second;
            if (cointatz[x] - to_string(x).size() <= ex) {
                cout << "cointatz" << endl;
            }
            else {
                cout << "random" << endl;
            }
            cin >> x;
        }
    }
    return 0;
}
