#include <bits/stdc++.h>
using namespace std;
using ll = long long;

const ll MOD = 1000000007;
const ll MAX_P = 1000000;
const ll MAX_N = 2 * MAX_P;

ll fact[MAX_N + 1];
ll inv_fact[MAX_N + 1];
ll powerOf4[MAX_P + 1];

ll power(ll a, ll b) {
    ll res = 1;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    ll t;
    powerOf4[0] = 1;
    for (ll i = 1; i <= MAX_P; i++) powerOf4[i] = powerOf4[i - 1] * 4 % MOD;
    fact[0] = 1;
    for (ll i = 1; i <= MAX_N; i++) fact[i] = fact[i - 1] * i % MOD;
    inv_fact[MAX_N] = power(fact[MAX_N], MOD - 2);
    for (ll i = MAX_N - 1; i >= 0; i--) inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    cin >> t;
    for (ll i = 0; i < t; i++) {
        ll p, m;
        cin >> p >> m;
        ll n = (2LL * p + m + 1) % MOD * powerOf4[p] % MOD;
        ll binom = fact[2LL * p] * inv_fact[p] % MOD * inv_fact[p] % MOD;
        ll E = (2LL * p + 1) % MOD * binom % MOD;
        ll inv_E = power(E, MOD - 2);
        ll res = n * inv_E % MOD;
        cout << res << '\n';
    }
}
