#ifndef __APPLE__
#include <bits/allocator.h>
#pragma GCC target("avx2,popcnt")
#pragma GCC optimize("O3")
#endif
#include "bits/stdc++.h"
#define int int64_t
using namespace std;
using ll = long long;

int n;
void rotate_clockwise(int amount, vector<int> &circle, int cnt) {
    vector<int> nvec(circle.size());
    for (int i = 0; i < (int)circle.size(); ++i) {
        nvec[(i + amount * (cnt-1)) % (int)circle.size()] = circle[i];
    }
    circle = nvec;
}

void simm(vector<int> &circle, int cnt) {
    vector<int> nvec(circle.size());
    if (cnt % 2 == 0) {
        for (int i = 0; i < (int)circle.size(); ++i) {
            nvec[(int)circle.size() - i - 1] = circle[i];
        }
    } else {
        for (int i = 0; i < (int)circle.size(); ++i) {
            nvec[((int)circle.size() - i)%(int)circle.size()] = circle[i];
        }
    }
    circle = nvec;
}

void solve() {
    cin >> n;
    vector<vector<int>> gex(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; ++i) {
        int cnt = min(i, 2 * n - 1 - i - 1) + 1 + n - 1;
        gex[i] = vector<int>(cnt);
        for (int j = 0; j < cnt; ++j) {
            cin >> gex[i][j];
        }
    }
    vector<vector<int>> circles(n + 1);
    for (int cnt = n; cnt >= 1; --cnt) {
        int offset = n - cnt;
        for (int i = offset + cnt / 2; i < (int)gex[offset].size() - offset - 1; ++i) {
            circles[cnt].push_back(gex[offset][i]);
        }
        for (int i = offset; i < 2 * n - 1 - offset; ++i) {
            circles[cnt].push_back(gex[i][(int)gex[i].size() - offset - 1]);
        }
        for (int i = (int)gex[offset].size() - offset - 2; i >= offset + 1 ; --i) {
            circles[cnt].push_back(gex[2 * n - 1 - offset - 1][i]);
        }
        for (int i = 2 * n - 1 - offset - 1; i >= offset + 1; --i) {
            circles[cnt].push_back(gex[i][offset]);
        }
        for (int i = offset; i < offset + cnt / 2; ++i) {
            circles[cnt].push_back(gex[offset][i]);
        }
    }
    string s;
    cin >> s;
    int cnt = 0;
    int is_normal_rot = 1;
    for (char c : s) {
        if (c == 'T') {
            is_normal_rot = -1 * is_normal_rot;
        }
        if (c == 'R') {
            cnt += is_normal_rot;
        } else if (c == 'L') {
            cnt += -is_normal_rot;
        }
    }
    cnt = (cnt % 6 + 6) % 6;
    for (int i = n; i >= 1; --i) {
        rotate_clockwise(cnt, circles[i], i);
        if (is_normal_rot == -1) simm(circles[i], i);
    }
    vector<int> indicies(n + 1);
    for (int cnt = n; cnt >= 1; --cnt) {
        int offset = n - cnt;

        for (int i = offset + cnt / 2; i < (int)gex[offset].size() - offset - 1; ++i) {
            gex[offset][i] = circles[cnt][indicies[cnt]++];
        }
        for (int i = offset; i < 2 * n - 1 - offset; ++i) {
            gex[i][(int)gex[i].size() - offset - 1] = circles[cnt][indicies[cnt]++];
        }
        for (int i = (int)gex[offset].size() - offset - 2; i >= offset + 1 ; --i) {
            gex[2 * n - 1 - offset - 1][i] = circles[cnt][indicies[cnt]++];
        }
        for (int i = 2 * n - 1 - offset - 1; i >= offset + 1; --i) {
            gex[i][offset] = circles[cnt][indicies[cnt]++];
        }
        for (int i = offset; i < offset + cnt / 2; ++i) {
            gex[offset][i] = circles[cnt][indicies[cnt]++];
        }
    }
    for (int i = 0; i < 2 * n - 1; ++i) {
        for (int j : gex[i]) {
            cout << j << " ";
        }
        cout << '\n';
    }
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    ll t = 1;
    while (t--) {
        solve();
    }
}