#include <cmath>
#include <iostream>
#include <limits>

struct point {
  int x;
  int y;
};

double distance(point minX, point maxX) {
  double b = (maxX.y - minX.y);
  double a = (maxX.x - minX.x);
  return std::abs(b + a * a / b) / std::sqrt((a * a) / (b * b) + 1);
}

void print(point minX, point maxX) {
  int b = (maxX.y - minX.y);
  int a = (maxX.x - minX.x);
  std::cout << a << " " << b << " " << 0 << "\n";
  std::cout << a << " " << b << " " << - (b * b + a * a) << "\n";
}

int main() {
  int n;
  std::cin >> n;
  point maxPointX{std::numeric_limits<int>::min(), 0}, minPointX{std::numeric_limits<int>::max(), 0};
  point maxPointY{0, std::numeric_limits<int>::min()}, minPointY{0, std::numeric_limits<int>::max()};
  for (size_t i = 0; i < n; ++i) {
    int x, y;
    std::cin >> x >> y;
    if (x > maxPointX.x) {
      maxPointX = {x, y};
    }
    if (x < minPointX.x) {
      minPointX = {x, y};
    }
    if (y > maxPointY.y) {
      maxPointY = {x, y};
    }
    if (y < minPointY.y) {
      minPointY = {x, y};
    }
  }
  auto distance1 = distance(minPointX, maxPointX);
  auto distance2 = distance(minPointY, maxPointY);
  if (distance1 >= distance2) {
    print(minPointX, maxPointX);
  } else {
    print(minPointY, maxPointY);
  }
}