#include <bits/stdc++.h>

using namespace std;

using ll = long long;

constexpr int N = 100'000'001;
char digits[N];
short collatz[N];
ll sum_collatz[10'000'001];
int trace[100000];

void eval_collatz(int limit) {
  for (int i = 1; i < N; i++)
    digits[i] = digits[i / 10] + 1;

  for (int i = 2; i < limit; i++) {
    int tback = 0;
    trace[0] = i;
    while (trace[tback] != 1) {
      if (trace[tback] > 100'000'000) {
        collatz[trace[--tback]] = -1;
        break;
      }
      if (collatz[trace[tback]]) break;
      if (trace[tback] % 2)
        trace[tback + 1] = (3 * trace[tback] + 1);
      else
        trace[tback + 1] = (trace[tback] / 2);
      tback++;
    }

    for (int j = tback; j > 0; j--)
      collatz[trace[j - 1]] = (collatz[trace[j]] == -1 ? -1 : digits[trace[j]] + collatz[trace[j]]);
  }

  for (int i = 2; i < limit; i++)
    sum_collatz[i] = sum_collatz[i - 1] + (collatz[i] == -1 ? 1000 : collatz[i]);
}

ll get_digits(ll x) {
  ll ans = 0;
  while (x) {
    x /= 10;
    ans++;
  }
  return ans;
}

int main() {
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  int n = 10'000'000;

  eval_collatz(n);

  //cout << *max_element(collatz, collatz + N) << "\n";
  //int jumped = count(collatz, collatz + 10'000'001, -1);
  //cout << jumped << endl;
  //cout << (double)(accumulate(collatz, collatz + 10'000'001, 0ll) + jumped) / 10'000'000;

  mt19937 gen;
  uniform_int_distribution<ll> rnd(0, 1e15);

  auto ask_collatz = [](ll x) {
    cout << "collatz" << endl;
    cin >> x;
    return x;
    //return x % 2 ? 3 * x + 1 : x / 2;
  };

  auto ask_random = [&](ll x) {
    cout << "random" << endl;
    cin >> x;
    return x;
    //return 3 * x + 1 + (rnd(gen) % (3 * x));
  };

  auto estimate_random = [](ll x) {
    return (sum_collatz[6 * x] - sum_collatz[3 * x]) / (3 * x);
  };

  int total = 0;
  int tests = 10000;
  cin >> tests;
  for (int i = 0; i < tests; i++) {
    //ll x = 2 + rnd(gen) % (10'000'000 - 1);
    //cout << "x0 = " << x << " ";
    //cout << endl;
    ll x;
    cin >> x;

    ll score = 0;
    while (x != 1) {
      if (x % 2 && x < n && (collatz[x] == -1 || collatz[x] > 700 || (x < n / 6 && estimate_random(x) < collatz[x] - 100))) {
        x = ask_random(x);
      } else {
        x = ask_collatz(x);
      }
      score += get_digits(x);
      if (x == 0) {
        return 0;
      }
    }
    //cout << "score " << score << endl;
    total += score;
  }
  //cout << "TOTAL " << total << endl;
  //cout << "AVG " << total / (double)tests << endl;

  return 0;
}