#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <ctime>
#include <random>
#include <climits>
#include <cmath>

using namespace std;

typedef long long ll;
typedef long double ld;

ll coll(ll x) {
    if (x & 1) {
        if (LLONG_MAX / 3 < x) 
            return LLONG_MAX;
        else 
            return 3 * x + 1;
    } 
    else 
        return x / 2;
}

ll dig(ll x) {
    ll res = 0;
    if (x == 0)
        return 0;
    while (x > 0) {
        res++;
        x /= 2;
    }
    return res;
}

std::map<ll, ll> precalc;

const ll maxTokenCount = 550;

ll calc(ll x) {
    if (precalc.find(x) != precalc.end()) {
        return precalc[x];
    }

    ll res = 0;
    while (x != 1 && x != LLONG_MAX && res < maxTokenCount) {
        x = coll(x);
        res += dig(x);
    }
    if (x == LLONG_MAX) 
        res = maxTokenCount + 10;
    precalc[x] = res;
    return res;
}

void solve() {
    ll x;
    std::cin >> x;
    while (calc(x) >= maxTokenCount) {
        std::cout << "Random" << std::endl;
        std::cin >> x;
    }
    while (x != 1) {
        std::cout << "Collatz" << std::endl;
        std::cin >> x;
    }
}

int main() {
    std::ios_base::sync_with_stdio(false);
    int t;
    std::cin >> t;
    while(t--) {
        solve();
    }
}

// ADGADGADGADGADGADGADGABC