#include <iostream>
#include <vector>

using namespace std;

typedef long long ll;

const ll mod = 2286661337;

ll bin_pow(ll a, ll n) {
    if (n == 0) {
        return 1;
    } else if (n % 2 == 1) {
        return a * bin_pow(a, n - 1) % mod;
    } else {
        ll b = bin_pow(a, n / 2);
        return b * b % mod;
    }
}

void solve() {
    int n; cin >> n;
    vector <int> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i];
    }
    ll ans1 = -1, ans2 = 1e18;
    for (int i = 0; i < (1 << n); i++) {
        ll x = 0, y = 0;
        for (int j = 0; j < n; j++) {
            if (i & (1 << j)) {
                x += a[j];
            } else {
                y += a[j];
            }
        }
        if (x == 0 || y == 0) {
            continue;
        }
        ans1 = max(ans1, x * y);
        ans2 = min(ans2, x * y);
    }
    cout << ans2 << ' ' << ans1;
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    // cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}