#include <iostream>
#include <vector>
#include <cmath>
#include <iomanip>
#define USE_MATH_DEFINES

using namespace std;

typedef long long ll;
typedef long double ld;

const ll mod = 2286661337;

ll bin_pow(ll a, ll n) {
    if (n == 0) {
        return 1;
    } else if (n % 2 == 1) {
        return a * bin_pow(a, n - 1) % mod;
    } else {
        ll b = bin_pow(a, n / 2);
        return b * b % mod;
    }
}

struct point{
    ll x, y;
};

ll dist(point a, point b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

void solve() {
    int n; cin >> n;
    vector <point> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i].x >> a[i].y;
    }
    ll max_dist = 0;
    int ind1, ind2;
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (dist(a[i], a[j]) > max_dist) {
                max_dist = dist(a[i], a[j]);
                ind1 = i;
                ind2 = j;
            }
        }
    }
    point v = {a[ind1].x - a[ind2].x, a[ind1].y - a[ind2].y};
    cout << v.x << ' ' << v.y << ' ' << -a[ind1].x * v.x - a[ind1].y * v.y << '\n';
    cout << v.x << ' ' << v.y << ' ' << -a[ind2].x * v.x - a[ind2].y * v.y << '\n';
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    //cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}