// #pragma GCC optimize("Ofast,unroll-loops")
#include <bits/stdc++.h>
// #pragma GCC target("avx2,sse")
#define int long long

using namespace std;

#define all(x) (x).begin(), (x).end()

using ll = long long;
using db = long double;

int N = 1;
vector<int> ACTUAL_A;

mt19937_64 rng{239};

void solve() {
    int n; cin >> n;
    vector<vector<int>> a;
    for (int i = 0; i < n; ++i) {
        a.emplace_back(n + i);
    }
    for (int i = n - 2; i >= 0; --i) {
        a.emplace_back(n + i);
    }

    for (auto& v : a) {
        for (auto& x : v) {
            cin >> x;
        }
    }

    string s; cin >> s;
    array<int, 2> state{0, 0};
    for (char c : s) {
        if (c == 'L') {
            state[1] += 5;
            state[1] %= 6;
        } else if (c == 'R') {
            state[1] += 1;
            state[1] %= 6;
        } else {
            state[0] ^= 1;
            state[1] = (6 - state[1]) % 6;
        }
    }

    if (state[0]) {
        for (auto& v : a) {
            reverse(all(v));
        }
    }

    vector<vector<array<int, 2>>> layers;
    layers.push_back(vector<array<int, 2>>{array<int, 2>{n - 1, n - 1}});

    array<int, 6> dx{0, -1, -1, 0, 1, 1};
    array<int, 6> dy{-1, -1, 1, 1, 1, -1};
    set<array<int, 2>> used;
    used.insert(array<int, 2>{n - 1, n - 1});
    auto check = [&](int x, int y) {
        if (x < 0 || x >= a.size()) {
            return false;
        }
        return y >= 0 && y < a[x].size();
    };
    while (layers.size() < n) {
        vector<array<int, 2>> nxt_layer;
        for (auto [x, y] : layers.back()) {
            for (int k = 0; k < 6; ++k) {
                int new_x = x + dx[k];
                int new_y = y + dy[k];
                if (!check(new_x, new_y)) {
                    continue;
                }

                if (used.find(array<int, 2>{new_x, new_y}) != used.end()) {
                    continue;
                }

                nxt_layer.push_back(array<int, 2>{new_x, new_y});
                used.insert(array<int,2>{new_x, new_y});
            }
        }
        layers.push_back(nxt_layer);
    }

    auto hex_rotate = [&]() {
        auto new_a = a;
        for (auto layer : layers) {
            for (int i = 0; i < layer.size(); ++i) {
                auto [x, y] = layer[i];
                auto [nxt_x, nxt_y] = layer[(i + 1) % layer.size()];
                new_a[nxt_x][nxt_y] = a[x][y];
            }
        }
        a = new_a;
    };

    cout << "STATE = " << state[0] << ' ' << state[1] << endl;

     for (auto layer : layers) {
        cout << "new layer\n";
        for (auto [x, y] : layer) {
            cout << x << ' ' << y << '\n';
        }
    }

    auto print_a = [&]() {
        for (auto v : a) {
            for (auto i : v) {
                cout << i << ' ';
            }
            cout << '\n';
        }
        cout << "\n";
    };

    for (int jj = 0; jj < state[1]; ++jj) {
        hex_rotate();
        print_a();
    }

    print_a();
}

int32_t main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.precision(20);

    solve();

    return 0;
}

C:\Users\Andrey\CLionProjects\cpp23_2\cmake-build-debug\cpp23_2.exe
3
4 1 8
3 5 1 7
2 1 6 1 8
1 7 1 9
8 9 9
LTR
STATE = 1 2
new layer
2 2
new layer
2 1
1 1
1 3
2 3
3 3
3 1
new layer
2 0
1 0
1 2
3 2
3 0
0 0
0 2
2 4
4 2
4 0
9 1 8
8 1 7 1
9 1 6 3 4
7 1 5 1
8 9 2

7 1 9
9 1 8 1
8 1 6 1 8
5 1 7 3
2 9 4

7 1 9
9 1 8 1
8 1 6 1 8
5 1 7 3
2 9 4


Process finished with exit code 0
