MOD = 10**9 + 7

import sys
input = sys.stdin.readline

t = int(input())
data = [tuple(map(int, input().split())) for _ in range(t)]
maxN = max(2 * p + m for p, m in data)

fact = [1] * (maxN + 1)
inv_fact = [1] * (maxN + 1)
for i in range(1, maxN + 1):
    fact[i] = fact[i - 1] * i % MOD

def modpow(a, e):
    res = 1
    while e:
        if e & 1:
            res = res * a % MOD
        a = a * a % MOD
        e >>= 1
    return res

inv_fact[maxN] = modpow(fact[maxN], MOD - 2)
for i in range(maxN, 0, -1):
    inv_fact[i - 1] = inv_fact[i] * i % MOD

def C(n, k):
    if k < 0 or k > n:
        return 0
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD

for p, m in data:
    N = 2 * p + m
    prefix = [0] * (p + 2)
    for s in range(p + 1):
        prefix[s + 1] = (prefix[s] + C(p, s) * pow(2, s, MOD)) % MOD

    ans = 0
    for k in range(N):
        smin = max(0, k - m)
        smax = min(k, p)
        numer = (prefix[smax + 1] - prefix[smin]) % MOD
        numer = numer * C(m, k - smin) % MOD
        denom = C(N, k)
        Sk = numer * modpow(denom, MOD - 2) % MOD
        ans = (ans + Sk) % MOD
    print(ans)