#include <iostream>
#include <vector>
using namespace std;


const long long MOD = 1000000007LL;

long long modpow(long long a, long long e) {
    long long r = 1 % MOD;
    a %= MOD;
    while (e > 0) {
        if (e & 1LL) r = (r * a) % MOD;
        a = (a * a) % MOD;
        e >>= 1;
    }
    return r;
}

long long invmod(long long x) {
    return modpow((x % MOD + MOD) % MOD, MOD - 2);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int test;
    vector<pair<int, int>> tests;
    int maxN = 0;
    if (!(cin >> test)) {
        return 0;
    }

    tests.reserve(test);

    for (int i = 0; i < test; ++i) {
        int p, m;
        cin >> p >> m;
        tests.emplace_back(p, m);
        int n = 2 * p + m;
        if (n > maxN) maxN = n;
    }

    int verN = maxN;
    vector<long long> fact(verN + 1), obrFact(verN + 1);
    fact[0] = 1;

    for (int i = 1; i <= verN; ++i) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    obrFact[verN] = invmod(fact[verN]);
    for (int i = verN; i >= 1; --i) {
        obrFact[i - 1] = obrFact[i] * i % MOD;
    }

    auto C = [&](int n, int k)->long long {
        if (k < 0 || k > n) return 0;
        return fact[n] * (obrFact[k] * obrFact[n - k] % MOD) % MOD;
        };

    for (auto& tm : tests) {
        int p = tm.first;
        int m = tm.second;
        int n = 2 * p + m;

        if (p == 0) {
            cout << 0 << endl;
            continue;
        }

        int Kmax = p + m;

        long long sumMod = 0;
        vector<long long> pow2(p + 1);
        pow2[0] = 1;

        for (int i = 1; i <= p; ++i) {
            pow2[i] = (pow2[i - 1] * 2) % MOD;
        }

        vector<long long> Cp(p + 1), Cm(m + 1);
        for (int s = 0; s <= p; ++s) Cp[s] = C(p, s);
        for (int t2 = 0; t2 <= m; ++t2) Cm[t2] = C(m, t2);

        for (int k = 0; k <= Kmax; ++k) {
            int minS = max(0, k - m);
            int maxS = min(k, p);
            long long ak = 0;

            for (int s = minS; s <= maxS; ++s) {
                long long add = Cp[s];
                add = (add * pow2[s]) % MOD;
                add = (add * Cm[k - s]) % MOD;
                ak += add;
                if (ak >= MOD) ak -= MOD;
            }

            long long denom = C(n, k);

            long long pr = 0;
            if (denom != 0) pr = ak * invmod(denom) % MOD;

            sumMod += pr;
            if (sumMod >= MOD) sumMod -= MOD;
        }

        cout << sumMod % MOD << endl;
    }
}