#include <iostream>
#include <vector>
#include <string>
#include <cmath>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;
    const int R = n - 1;
    const int rows = 2 * n - 1;

    auto row_len = [&](int i) -> int {              
        return 2 * R + 1 - abs(i - R);
    };
    auto qmin = [&](int z) -> int {                 
        return (z < 0) ? (-R - z) : (-R);
    };

    vector<vector<int>> a(rows);
    for (int i = 0; i < rows; ++i) {
        int len = row_len(i);
        a[i].resize(len);
        for (int j = 0; j < len; ++j) cin >> a[i][j];
    }

    string ops;
    getline(cin, ops);
    getline(cin, ops);

    int perm[3] = {0, 1, 2};
    int sign[3] = {1, 1, 1};

    auto compose = [&](const int pO[3], const int sO[3]) {
        int pN[3], sN[3];
        for (int k = 0; k < 3; ++k) {
            pN[k] = perm[ pO[k] ];
            sN[k] = sO[k] * sign[ pO[k] ];
        }
        for (int k = 0; k < 3; ++k) { perm[k] = pN[k]; sign[k] = sN[k]; }
    };

    const int pT[3] = {1, 0, 2}; const int sT[3] = { 1, 1, 1};
    const int pR[3] = {2, 0, 1}; const int sR[3] = {-1,-1,-1};
    const int pL[3] = {1, 2, 0}; const int sL[3] = {-1,-1,-1};

    for (char c : ops) {
        if (c == 'R') compose(pR, sR);
        else if (c == 'L') compose(pL, sL);
        else if (c == 'T') compose(pT, sT);
    }

    vector<vector<int>> out(rows);
    for (int i = 0; i < rows; ++i) out[i].assign(row_len(i), 0);

    for (int i = 0; i < rows; ++i) {
        int z = i - R;
        int len = (int)a[i].size();
        int x0 = qmin(z);
        for (int j = 0; j < len; ++j) {
            int x = x0 + j;
            int y = -x - z;

            int v[3] = {x, y, z};
            int w[3];
            w[0] = sign[0] * v[ perm[0] ];
            w[1] = sign[1] * v[ perm[1] ];
            w[2] = sign[2] * v[ perm[2] ];

            int x2 = w[0], z2 = w[2];
            int i2 = z2 + R;
            int j2 = x2 - qmin(z2);
            out[i2][j2] = a[i][j];
        }
    }

    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < (int)out[i].size(); ++j) {
            if (j) cout << ' ';
            cout << out[i][j];
        }
        cout << '\n';
    }
    return 0;
}

