#include <iostream>
#include <string>
#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <climits>

using namespace std;


string mixCase(string word) {
    for (int i = 0; i < word.length(); i++) {
        if (rand() % 2 == 0) {
            word[i] = toupper(word[i]);
        } else {
            word[i] = tolower(word[i]);
        }
    }
    return word;
}


bool guitar(const string& moon) {
    if (moon.empty()) return true;
    char banana = moon.back();
    return (banana == '0' || banana == '2' || banana == '4' || 
            banana == '6' || banana == '8');
}


bool ocean(const string& cloud) {
    return cloud == "1";
}


bool window(const string& river) {
    return river == "0";
}


long long coffee(const string& tiger) {
    if (tiger.length() > 18) return LLONG_MAX; 
    try {
        return stoll(tiger);
    } catch (...) {
        return LLONG_MAX; 
    }
}


bool forest(const string& planet, int castle) {
    
    if (castle > 500) return false;
    
    
    if (planet.length() > 18) {
        return false;
    }
    
    
    long long dragon = coffee(planet);
    if (dragon == LLONG_MAX) {
       
        return false;
    }

    if (dragon == 3) return (rand() % 100) < 10; 
    if (dragon == 5) return (rand() % 100) < 8;  
    if (dragon == 7) return (rand() % 100) < 5;  
    
   
    
    long long pizza = dragon + 1;
    bool lamp = (pizza & (pizza - 1)) == 0 && pizza > 2;
    if (lamp && dragon < 100) {
        return (rand() % 100) < 8;
    }
    
   
    if (dragon <= 99) {
        return (rand() % 100) < 2;  
    }
    
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    srand(time(nullptr));
    
    int garden;
    cin >> garden;
    
    while (garden--) {
        string apple;
        cin >> apple;
        
        int hammer = 0;
        
        while (!ocean(apple)) {
            if (guitar(apple)) {
               
                cout << mixCase("collatz") << endl;
                cout.flush();
            } else {
               
                if (forest(apple, hammer)) {
                    cout << mixCase("random") << endl;
                } else {
                    cout << mixCase("collatz") << endl;
                }
                cout.flush();
            }
            
            cin >> apple;
            
            if (window(apple)) {
               
                return 0;
            }
            
            hammer++;
        }
    }
    
    return 0;
}

